/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration properties of a flywheel iteration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlywheelIterationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<FlywheelIterationProperties.Builder, FlywheelIterationProperties> {
    private static final SdkField<String> FLYWHEEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelArn").getter(getter(FlywheelIterationProperties::flywheelArn))
            .setter(setter(Builder::flywheelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelArn").build()).build();

    private static final SdkField<String> FLYWHEEL_ITERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlywheelIterationId").getter(getter(FlywheelIterationProperties::flywheelIterationId))
            .setter(setter(Builder::flywheelIterationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlywheelIterationId").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(FlywheelIterationProperties::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(FlywheelIterationProperties::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FlywheelIterationProperties::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(FlywheelIterationProperties::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> EVALUATED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluatedModelArn").getter(getter(FlywheelIterationProperties::evaluatedModelArn))
            .setter(setter(Builder::evaluatedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedModelArn").build()).build();

    private static final SdkField<FlywheelModelEvaluationMetrics> EVALUATED_MODEL_METRICS_FIELD = SdkField
            .<FlywheelModelEvaluationMetrics> builder(MarshallingType.SDK_POJO).memberName("EvaluatedModelMetrics")
            .getter(getter(FlywheelIterationProperties::evaluatedModelMetrics)).setter(setter(Builder::evaluatedModelMetrics))
            .constructor(FlywheelModelEvaluationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedModelMetrics").build())
            .build();

    private static final SdkField<String> TRAINED_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainedModelArn").getter(getter(FlywheelIterationProperties::trainedModelArn))
            .setter(setter(Builder::trainedModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainedModelArn").build()).build();

    private static final SdkField<FlywheelModelEvaluationMetrics> TRAINED_MODEL_METRICS_FIELD = SdkField
            .<FlywheelModelEvaluationMetrics> builder(MarshallingType.SDK_POJO).memberName("TrainedModelMetrics")
            .getter(getter(FlywheelIterationProperties::trainedModelMetrics)).setter(setter(Builder::trainedModelMetrics))
            .constructor(FlywheelModelEvaluationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainedModelMetrics").build())
            .build();

    private static final SdkField<String> EVALUATION_MANIFEST_S3_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EvaluationManifestS3Prefix")
            .getter(getter(FlywheelIterationProperties::evaluationManifestS3Prefix))
            .setter(setter(Builder::evaluationManifestS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationManifestS3Prefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLYWHEEL_ARN_FIELD,
            FLYWHEEL_ITERATION_ID_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, MESSAGE_FIELD,
            EVALUATED_MODEL_ARN_FIELD, EVALUATED_MODEL_METRICS_FIELD, TRAINED_MODEL_ARN_FIELD, TRAINED_MODEL_METRICS_FIELD,
            EVALUATION_MANIFEST_S3_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flywheelArn;

    private final String flywheelIterationId;

    private final Instant creationTime;

    private final Instant endTime;

    private final String status;

    private final String message;

    private final String evaluatedModelArn;

    private final FlywheelModelEvaluationMetrics evaluatedModelMetrics;

    private final String trainedModelArn;

    private final FlywheelModelEvaluationMetrics trainedModelMetrics;

    private final String evaluationManifestS3Prefix;

    private FlywheelIterationProperties(BuilderImpl builder) {
        this.flywheelArn = builder.flywheelArn;
        this.flywheelIterationId = builder.flywheelIterationId;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.message = builder.message;
        this.evaluatedModelArn = builder.evaluatedModelArn;
        this.evaluatedModelMetrics = builder.evaluatedModelMetrics;
        this.trainedModelArn = builder.trainedModelArn;
        this.trainedModelMetrics = builder.trainedModelMetrics;
        this.evaluationManifestS3Prefix = builder.evaluationManifestS3Prefix;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String flywheelArn() {
        return flywheelArn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String flywheelIterationId() {
        return flywheelIterationId;
    }

    /**
     * <p>
     * The creation start time of the flywheel iteration.
     * </p>
     * 
     * @return The creation start time of the flywheel iteration.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The completion time of this flywheel iteration.
     * </p>
     * 
     * @return The completion time of this flywheel iteration.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The status of the flywheel iteration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlywheelIterationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flywheel iteration.
     * @see FlywheelIterationStatus
     */
    public final FlywheelIterationStatus status() {
        return FlywheelIterationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the flywheel iteration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlywheelIterationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flywheel iteration.
     * @see FlywheelIterationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A description of the status of the flywheel iteration.
     * </p>
     * 
     * @return A description of the status of the flywheel iteration.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The ARN of the evaluated model associated with this flywheel iteration.
     * </p>
     * 
     * @return The ARN of the evaluated model associated with this flywheel iteration.
     */
    public final String evaluatedModelArn() {
        return evaluatedModelArn;
    }

    /**
     * Returns the value of the EvaluatedModelMetrics property for this object.
     * 
     * @return The value of the EvaluatedModelMetrics property for this object.
     */
    public final FlywheelModelEvaluationMetrics evaluatedModelMetrics() {
        return evaluatedModelMetrics;
    }

    /**
     * <p>
     * The ARN of the trained model associated with this flywheel iteration.
     * </p>
     * 
     * @return The ARN of the trained model associated with this flywheel iteration.
     */
    public final String trainedModelArn() {
        return trainedModelArn;
    }

    /**
     * <p>
     * The metrics associated with the trained model.
     * </p>
     * 
     * @return The metrics associated with the trained model.
     */
    public final FlywheelModelEvaluationMetrics trainedModelMetrics() {
        return trainedModelMetrics;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String evaluationManifestS3Prefix() {
        return evaluationManifestS3Prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flywheelArn());
        hashCode = 31 * hashCode + Objects.hashCode(flywheelIterationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(evaluatedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(evaluatedModelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainedModelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationManifestS3Prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlywheelIterationProperties)) {
            return false;
        }
        FlywheelIterationProperties other = (FlywheelIterationProperties) obj;
        return Objects.equals(flywheelArn(), other.flywheelArn())
                && Objects.equals(flywheelIterationId(), other.flywheelIterationId())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(evaluatedModelArn(), other.evaluatedModelArn())
                && Objects.equals(evaluatedModelMetrics(), other.evaluatedModelMetrics())
                && Objects.equals(trainedModelArn(), other.trainedModelArn())
                && Objects.equals(trainedModelMetrics(), other.trainedModelMetrics())
                && Objects.equals(evaluationManifestS3Prefix(), other.evaluationManifestS3Prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlywheelIterationProperties").add("FlywheelArn", flywheelArn())
                .add("FlywheelIterationId", flywheelIterationId()).add("CreationTime", creationTime()).add("EndTime", endTime())
                .add("Status", statusAsString()).add("Message", message()).add("EvaluatedModelArn", evaluatedModelArn())
                .add("EvaluatedModelMetrics", evaluatedModelMetrics()).add("TrainedModelArn", trainedModelArn())
                .add("TrainedModelMetrics", trainedModelMetrics())
                .add("EvaluationManifestS3Prefix", evaluationManifestS3Prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlywheelArn":
            return Optional.ofNullable(clazz.cast(flywheelArn()));
        case "FlywheelIterationId":
            return Optional.ofNullable(clazz.cast(flywheelIterationId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "EvaluatedModelArn":
            return Optional.ofNullable(clazz.cast(evaluatedModelArn()));
        case "EvaluatedModelMetrics":
            return Optional.ofNullable(clazz.cast(evaluatedModelMetrics()));
        case "TrainedModelArn":
            return Optional.ofNullable(clazz.cast(trainedModelArn()));
        case "TrainedModelMetrics":
            return Optional.ofNullable(clazz.cast(trainedModelMetrics()));
        case "EvaluationManifestS3Prefix":
            return Optional.ofNullable(clazz.cast(evaluationManifestS3Prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FlywheelArn", FLYWHEEL_ARN_FIELD);
        map.put("FlywheelIterationId", FLYWHEEL_ITERATION_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("EvaluatedModelArn", EVALUATED_MODEL_ARN_FIELD);
        map.put("EvaluatedModelMetrics", EVALUATED_MODEL_METRICS_FIELD);
        map.put("TrainedModelArn", TRAINED_MODEL_ARN_FIELD);
        map.put("TrainedModelMetrics", TRAINED_MODEL_METRICS_FIELD);
        map.put("EvaluationManifestS3Prefix", EVALUATION_MANIFEST_S3_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlywheelIterationProperties, T> g) {
        return obj -> g.apply((FlywheelIterationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlywheelIterationProperties> {
        /**
         * <p/>
         * 
         * @param flywheelArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelArn(String flywheelArn);

        /**
         * <p/>
         * 
         * @param flywheelIterationId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flywheelIterationId(String flywheelIterationId);

        /**
         * <p>
         * The creation start time of the flywheel iteration.
         * </p>
         * 
         * @param creationTime
         *        The creation start time of the flywheel iteration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The completion time of this flywheel iteration.
         * </p>
         * 
         * @param endTime
         *        The completion time of this flywheel iteration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The status of the flywheel iteration.
         * </p>
         * 
         * @param status
         *        The status of the flywheel iteration.
         * @see FlywheelIterationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlywheelIterationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the flywheel iteration.
         * </p>
         * 
         * @param status
         *        The status of the flywheel iteration.
         * @see FlywheelIterationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlywheelIterationStatus
         */
        Builder status(FlywheelIterationStatus status);

        /**
         * <p>
         * A description of the status of the flywheel iteration.
         * </p>
         * 
         * @param message
         *        A description of the status of the flywheel iteration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The ARN of the evaluated model associated with this flywheel iteration.
         * </p>
         * 
         * @param evaluatedModelArn
         *        The ARN of the evaluated model associated with this flywheel iteration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedModelArn(String evaluatedModelArn);

        /**
         * Sets the value of the EvaluatedModelMetrics property for this object.
         *
         * @param evaluatedModelMetrics
         *        The new value for the EvaluatedModelMetrics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatedModelMetrics(FlywheelModelEvaluationMetrics evaluatedModelMetrics);

        /**
         * Sets the value of the EvaluatedModelMetrics property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FlywheelModelEvaluationMetrics.Builder}
         * avoiding the need to create one manually via {@link FlywheelModelEvaluationMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlywheelModelEvaluationMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluatedModelMetrics(FlywheelModelEvaluationMetrics)}.
         * 
         * @param evaluatedModelMetrics
         *        a consumer that will call methods on {@link FlywheelModelEvaluationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluatedModelMetrics(FlywheelModelEvaluationMetrics)
         */
        default Builder evaluatedModelMetrics(Consumer<FlywheelModelEvaluationMetrics.Builder> evaluatedModelMetrics) {
            return evaluatedModelMetrics(FlywheelModelEvaluationMetrics.builder().applyMutation(evaluatedModelMetrics).build());
        }

        /**
         * <p>
         * The ARN of the trained model associated with this flywheel iteration.
         * </p>
         * 
         * @param trainedModelArn
         *        The ARN of the trained model associated with this flywheel iteration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelArn(String trainedModelArn);

        /**
         * <p>
         * The metrics associated with the trained model.
         * </p>
         * 
         * @param trainedModelMetrics
         *        The metrics associated with the trained model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainedModelMetrics(FlywheelModelEvaluationMetrics trainedModelMetrics);

        /**
         * <p>
         * The metrics associated with the trained model.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlywheelModelEvaluationMetrics.Builder}
         * avoiding the need to create one manually via {@link FlywheelModelEvaluationMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlywheelModelEvaluationMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #trainedModelMetrics(FlywheelModelEvaluationMetrics)}.
         * 
         * @param trainedModelMetrics
         *        a consumer that will call methods on {@link FlywheelModelEvaluationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainedModelMetrics(FlywheelModelEvaluationMetrics)
         */
        default Builder trainedModelMetrics(Consumer<FlywheelModelEvaluationMetrics.Builder> trainedModelMetrics) {
            return trainedModelMetrics(FlywheelModelEvaluationMetrics.builder().applyMutation(trainedModelMetrics).build());
        }

        /**
         * <p/>
         * 
         * @param evaluationManifestS3Prefix
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationManifestS3Prefix(String evaluationManifestS3Prefix);
    }

    static final class BuilderImpl implements Builder {
        private String flywheelArn;

        private String flywheelIterationId;

        private Instant creationTime;

        private Instant endTime;

        private String status;

        private String message;

        private String evaluatedModelArn;

        private FlywheelModelEvaluationMetrics evaluatedModelMetrics;

        private String trainedModelArn;

        private FlywheelModelEvaluationMetrics trainedModelMetrics;

        private String evaluationManifestS3Prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(FlywheelIterationProperties model) {
            flywheelArn(model.flywheelArn);
            flywheelIterationId(model.flywheelIterationId);
            creationTime(model.creationTime);
            endTime(model.endTime);
            status(model.status);
            message(model.message);
            evaluatedModelArn(model.evaluatedModelArn);
            evaluatedModelMetrics(model.evaluatedModelMetrics);
            trainedModelArn(model.trainedModelArn);
            trainedModelMetrics(model.trainedModelMetrics);
            evaluationManifestS3Prefix(model.evaluationManifestS3Prefix);
        }

        public final String getFlywheelArn() {
            return flywheelArn;
        }

        public final void setFlywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
        }

        @Override
        public final Builder flywheelArn(String flywheelArn) {
            this.flywheelArn = flywheelArn;
            return this;
        }

        public final String getFlywheelIterationId() {
            return flywheelIterationId;
        }

        public final void setFlywheelIterationId(String flywheelIterationId) {
            this.flywheelIterationId = flywheelIterationId;
        }

        @Override
        public final Builder flywheelIterationId(String flywheelIterationId) {
            this.flywheelIterationId = flywheelIterationId;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlywheelIterationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getEvaluatedModelArn() {
            return evaluatedModelArn;
        }

        public final void setEvaluatedModelArn(String evaluatedModelArn) {
            this.evaluatedModelArn = evaluatedModelArn;
        }

        @Override
        public final Builder evaluatedModelArn(String evaluatedModelArn) {
            this.evaluatedModelArn = evaluatedModelArn;
            return this;
        }

        public final FlywheelModelEvaluationMetrics.Builder getEvaluatedModelMetrics() {
            return evaluatedModelMetrics != null ? evaluatedModelMetrics.toBuilder() : null;
        }

        public final void setEvaluatedModelMetrics(FlywheelModelEvaluationMetrics.BuilderImpl evaluatedModelMetrics) {
            this.evaluatedModelMetrics = evaluatedModelMetrics != null ? evaluatedModelMetrics.build() : null;
        }

        @Override
        public final Builder evaluatedModelMetrics(FlywheelModelEvaluationMetrics evaluatedModelMetrics) {
            this.evaluatedModelMetrics = evaluatedModelMetrics;
            return this;
        }

        public final String getTrainedModelArn() {
            return trainedModelArn;
        }

        public final void setTrainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
        }

        @Override
        public final Builder trainedModelArn(String trainedModelArn) {
            this.trainedModelArn = trainedModelArn;
            return this;
        }

        public final FlywheelModelEvaluationMetrics.Builder getTrainedModelMetrics() {
            return trainedModelMetrics != null ? trainedModelMetrics.toBuilder() : null;
        }

        public final void setTrainedModelMetrics(FlywheelModelEvaluationMetrics.BuilderImpl trainedModelMetrics) {
            this.trainedModelMetrics = trainedModelMetrics != null ? trainedModelMetrics.build() : null;
        }

        @Override
        public final Builder trainedModelMetrics(FlywheelModelEvaluationMetrics trainedModelMetrics) {
            this.trainedModelMetrics = trainedModelMetrics;
            return this;
        }

        public final String getEvaluationManifestS3Prefix() {
            return evaluationManifestS3Prefix;
        }

        public final void setEvaluationManifestS3Prefix(String evaluationManifestS3Prefix) {
            this.evaluationManifestS3Prefix = evaluationManifestS3Prefix;
        }

        @Override
        public final Builder evaluationManifestS3Prefix(String evaluationManifestS3Prefix) {
            this.evaluationManifestS3Prefix = evaluationManifestS3Prefix;
            return this;
        }

        @Override
        public FlywheelIterationProperties build() {
            return new FlywheelIterationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
