/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EntityRecognizerDataFormat {
    COMPREHEND_CSV("COMPREHEND_CSV"),
    AUGMENTED_MANIFEST("AUGMENTED_MANIFEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EntityRecognizerDataFormat> VALUE_MAP;
    private final String value;

    private EntityRecognizerDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EntityRecognizerDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EntityRecognizerDataFormat> knownValues() {
        EnumSet<EntityRecognizerDataFormat> knownValues = EnumSet.allOf(EntityRecognizerDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EntityRecognizerDataFormat.class, EntityRecognizerDataFormat::toString);
    }
}

