/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.KeyPhrasesDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.KeyPhrasesDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKeyPhrasesDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListKeyPhrasesDetectionJobsResponse> {
    private static final SdkField<List<KeyPhrasesDetectionJobProperties>> KEY_PHRASES_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeyPhrasesDetectionJobPropertiesList").getter(ListKeyPhrasesDetectionJobsResponse.getter(ListKeyPhrasesDetectionJobsResponse::keyPhrasesDetectionJobPropertiesList)).setter(ListKeyPhrasesDetectionJobsResponse.setter(Builder::keyPhrasesDetectionJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPhrasesDetectionJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyPhrasesDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListKeyPhrasesDetectionJobsResponse.getter(ListKeyPhrasesDetectionJobsResponse::nextToken)).setter(ListKeyPhrasesDetectionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PHRASES_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListKeyPhrasesDetectionJobsResponse.memberNameToFieldInitializer();
    private final List<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList;
    private final String nextToken;

    private ListKeyPhrasesDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPhrasesDetectionJobPropertiesList = builder.keyPhrasesDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasKeyPhrasesDetectionJobPropertiesList() {
        return this.keyPhrasesDetectionJobPropertiesList != null && !(this.keyPhrasesDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList() {
        return this.keyPhrasesDetectionJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeyPhrasesDetectionJobPropertiesList() ? this.keyPhrasesDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyPhrasesDetectionJobsResponse)) {
            return false;
        }
        ListKeyPhrasesDetectionJobsResponse other = (ListKeyPhrasesDetectionJobsResponse)((Object)obj);
        return this.hasKeyPhrasesDetectionJobPropertiesList() == other.hasKeyPhrasesDetectionJobPropertiesList() && Objects.equals(this.keyPhrasesDetectionJobPropertiesList(), other.keyPhrasesDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKeyPhrasesDetectionJobsResponse").add("KeyPhrasesDetectionJobPropertiesList", this.hasKeyPhrasesDetectionJobPropertiesList() ? this.keyPhrasesDetectionJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPhrasesDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.keyPhrasesDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyPhrasesDetectionJobPropertiesList", KEY_PHRASES_DETECTION_JOB_PROPERTIES_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKeyPhrasesDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListKeyPhrasesDetectionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyPhrasesDetectionJobsResponse model) {
            super(model);
            this.keyPhrasesDetectionJobPropertiesList(model.keyPhrasesDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<KeyPhrasesDetectionJobProperties.Builder> getKeyPhrasesDetectionJobPropertiesList() {
            List<KeyPhrasesDetectionJobProperties.Builder> result = KeyPhrasesDetectionJobPropertiesListCopier.copyToBuilder(this.keyPhrasesDetectionJobPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeyPhrasesDetectionJobPropertiesList(Collection<KeyPhrasesDetectionJobProperties.BuilderImpl> keyPhrasesDetectionJobPropertiesList) {
            this.keyPhrasesDetectionJobPropertiesList = KeyPhrasesDetectionJobPropertiesListCopier.copyFromBuilder(keyPhrasesDetectionJobPropertiesList);
        }

        @Override
        public final Builder keyPhrasesDetectionJobPropertiesList(Collection<KeyPhrasesDetectionJobProperties> keyPhrasesDetectionJobPropertiesList) {
            this.keyPhrasesDetectionJobPropertiesList = KeyPhrasesDetectionJobPropertiesListCopier.copy(keyPhrasesDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrasesDetectionJobPropertiesList(KeyPhrasesDetectionJobProperties ... keyPhrasesDetectionJobPropertiesList) {
            this.keyPhrasesDetectionJobPropertiesList(Arrays.asList(keyPhrasesDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrasesDetectionJobPropertiesList(Consumer<KeyPhrasesDetectionJobProperties.Builder> ... keyPhrasesDetectionJobPropertiesList) {
            this.keyPhrasesDetectionJobPropertiesList(Stream.of(keyPhrasesDetectionJobPropertiesList).map(c -> (KeyPhrasesDetectionJobProperties)((KeyPhrasesDetectionJobProperties.Builder)KeyPhrasesDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKeyPhrasesDetectionJobsResponse build() {
            return new ListKeyPhrasesDetectionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKeyPhrasesDetectionJobsResponse> {
        public Builder keyPhrasesDetectionJobPropertiesList(Collection<KeyPhrasesDetectionJobProperties> var1);

        public Builder keyPhrasesDetectionJobPropertiesList(KeyPhrasesDetectionJobProperties ... var1);

        public Builder keyPhrasesDetectionJobPropertiesList(Consumer<KeyPhrasesDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

