/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.PiiEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PiiEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PiiEntity> {
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(PiiEntity.getter(PiiEntity::score)).setter(PiiEntity.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(PiiEntity.getter(PiiEntity::typeAsString)).setter(PiiEntity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> BEGIN_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BeginOffset").getter(PiiEntity.getter(PiiEntity::beginOffset)).setter(PiiEntity.setter(Builder::beginOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffset").build()}).build();
    private static final SdkField<Integer> END_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EndOffset").getter(PiiEntity.getter(PiiEntity::endOffset)).setter(PiiEntity.setter(Builder::endOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCORE_FIELD, TYPE_FIELD, BEGIN_OFFSET_FIELD, END_OFFSET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Score", SCORE_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("BeginOffset", BEGIN_OFFSET_FIELD);
            this.put("EndOffset", END_OFFSET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Float score;
    private final String type;
    private final Integer beginOffset;
    private final Integer endOffset;

    private PiiEntity(BuilderImpl builder) {
        this.score = builder.score;
        this.type = builder.type;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
    }

    public final Float score() {
        return this.score;
    }

    public final PiiEntityType type() {
        return PiiEntityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer beginOffset() {
        return this.beginOffset;
    }

    public final Integer endOffset() {
        return this.endOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PiiEntity)) {
            return false;
        }
        PiiEntity other = (PiiEntity)obj;
        return Objects.equals(this.score(), other.score()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset());
    }

    public final String toString() {
        return ToString.builder((String)"PiiEntity").add("Score", (Object)this.score()).add("Type", (Object)this.typeAsString()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PiiEntity, T> g) {
        return obj -> g.apply((PiiEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float score;
        private String type;
        private Integer beginOffset;
        private Integer endOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(PiiEntity model) {
            this.score(model.score);
            this.type(model.type);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
        }

        public final Float getScore() {
            return this.score;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PiiEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public PiiEntity build() {
            return new PiiEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PiiEntity> {
        public Builder score(Float var1);

        public Builder type(String var1);

        public Builder type(PiiEntityType var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);
    }
}

