/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;

public class ListEntityRecognizersPublisher
implements SdkPublisher<ListEntityRecognizersResponse> {
    private final ComprehendAsyncClient client;
    private final ListEntityRecognizersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntityRecognizersPublisher(ComprehendAsyncClient client, ListEntityRecognizersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntityRecognizersPublisher(ComprehendAsyncClient client, ListEntityRecognizersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntityRecognizersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntityRecognizersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEntityRecognizersResponseFetcher
    implements AsyncPageFetcher<ListEntityRecognizersResponse> {
        private ListEntityRecognizersResponseFetcher() {
        }

        public boolean hasNextPage(ListEntityRecognizersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntityRecognizersResponse> nextPage(ListEntityRecognizersResponse previousPage) {
            if (previousPage == null) {
                return ListEntityRecognizersPublisher.this.client.listEntityRecognizers(ListEntityRecognizersPublisher.this.firstRequest);
            }
            return ListEntityRecognizersPublisher.this.client.listEntityRecognizers((ListEntityRecognizersRequest)((Object)ListEntityRecognizersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

