/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.DocumentReaderConfig;
import software.amazon.awssdk.services.comprehend.model.InputFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(InputDataConfig.getter(InputDataConfig::s3Uri)).setter(InputDataConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFormat").getter(InputDataConfig.getter(InputDataConfig::inputFormatAsString)).setter(InputDataConfig.setter(Builder::inputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()}).build();
    private static final SdkField<DocumentReaderConfig> DOCUMENT_READER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentReaderConfig").getter(InputDataConfig.getter(InputDataConfig::documentReaderConfig)).setter(InputDataConfig.setter(Builder::documentReaderConfig)).constructor(DocumentReaderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentReaderConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, INPUT_FORMAT_FIELD, DOCUMENT_READER_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String inputFormat;
    private final DocumentReaderConfig documentReaderConfig;

    private InputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.inputFormat = builder.inputFormat;
        this.documentReaderConfig = builder.documentReaderConfig;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final InputFormat inputFormat() {
        return InputFormat.fromValue(this.inputFormat);
    }

    public final String inputFormatAsString() {
        return this.inputFormat;
    }

    public final DocumentReaderConfig documentReaderConfig() {
        return this.documentReaderConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentReaderConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.inputFormatAsString(), other.inputFormatAsString()) && Objects.equals(this.documentReaderConfig(), other.documentReaderConfig());
    }

    public final String toString() {
        return ToString.builder((String)"InputDataConfig").add("S3Uri", (Object)this.s3Uri()).add("InputFormat", (Object)this.inputFormatAsString()).add("DocumentReaderConfig", (Object)this.documentReaderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "InputFormat": {
                return Optional.ofNullable(clazz.cast(this.inputFormatAsString()));
            }
            case "DocumentReaderConfig": {
                return Optional.ofNullable(clazz.cast(this.documentReaderConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String inputFormat;
        private DocumentReaderConfig documentReaderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            this.s3Uri(model.s3Uri);
            this.inputFormat(model.inputFormat);
            this.documentReaderConfig(model.documentReaderConfig);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final DocumentReaderConfig.Builder getDocumentReaderConfig() {
            return this.documentReaderConfig != null ? this.documentReaderConfig.toBuilder() : null;
        }

        public final void setDocumentReaderConfig(DocumentReaderConfig.BuilderImpl documentReaderConfig) {
            this.documentReaderConfig = documentReaderConfig != null ? documentReaderConfig.build() : null;
        }

        @Override
        public final Builder documentReaderConfig(DocumentReaderConfig documentReaderConfig) {
            this.documentReaderConfig = documentReaderConfig;
            return this;
        }

        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDataConfig> {
        public Builder s3Uri(String var1);

        public Builder inputFormat(String var1);

        public Builder inputFormat(InputFormat var1);

        public Builder documentReaderConfig(DocumentReaderConfig var1);

        default public Builder documentReaderConfig(Consumer<DocumentReaderConfig.Builder> documentReaderConfig) {
            return this.documentReaderConfig((DocumentReaderConfig)((DocumentReaderConfig.Builder)DocumentReaderConfig.builder().applyMutation(documentReaderConfig)).build());
        }
    }
}

