/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.BatchSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest;
import software.amazon.awssdk.services.comprehend.model.ClassifyDocumentResponse;
import software.amazon.awssdk.services.comprehend.model.ComprehendException;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.ConcurrentModificationException;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest;
import software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageResponse;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest;
import software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSentimentResponse;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest;
import software.amazon.awssdk.services.comprehend.model.DetectSyntaxResponse;
import software.amazon.awssdk.services.comprehend.model.InternalServerException;
import software.amazon.awssdk.services.comprehend.model.InvalidFilterException;
import software.amazon.awssdk.services.comprehend.model.InvalidRequestException;
import software.amazon.awssdk.services.comprehend.model.JobNotFoundException;
import software.amazon.awssdk.services.comprehend.model.KmsKeyValidationException;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest;
import software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEndpointsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest;
import software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.comprehend.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;
import software.amazon.awssdk.services.comprehend.model.ResourceInUseException;
import software.amazon.awssdk.services.comprehend.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.ResourceNotFoundException;
import software.amazon.awssdk.services.comprehend.model.ResourceUnavailableException;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest;
import software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierResponse;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest;
import software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerResponse;
import software.amazon.awssdk.services.comprehend.model.TagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.TagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.comprehend.model.TooManyRequestsException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagKeysException;
import software.amazon.awssdk.services.comprehend.model.TooManyTagsException;
import software.amazon.awssdk.services.comprehend.model.UnsupportedLanguageException;
import software.amazon.awssdk.services.comprehend.model.UntagResourceRequest;
import software.amazon.awssdk.services.comprehend.model.UntagResourceResponse;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.comprehend.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ClassifyDocumentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.CreateEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DeleteEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribePiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DescribeTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectDominantLanguageRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectKeyPhrasesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectPiiEntitiesRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSentimentRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.DetectSyntaxRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassificationJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDocumentClassifiersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListDominantLanguageDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEndpointsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEntityRecognizersRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListEventsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListKeyPhrasesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListPiiEntitiesDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListSentimentDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.ListTopicsDetectionJobsRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDocumentClassificationJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StartTopicsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopDominantLanguageDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopEventsDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopKeyPhrasesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopPiiEntitiesDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopSentimentDetectionJobRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingDocumentClassifierRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.StopTrainingEntityRecognizerRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.comprehend.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ComprehendAsyncClient}.
 *
 * @see ComprehendAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultComprehendAsyncClient implements ComprehendAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultComprehendAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultComprehendAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon
     * Comprehend can detect, see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon
     * Comprehend Supported Languages</a>.
     * </p>
     *
     * @param batchDetectDominantLanguageRequest
     * @return A Java Future containing the result of the BatchDetectDominantLanguage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectDominantLanguage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectDominantLanguageResponse> batchDetectDominantLanguage(
            BatchDetectDominantLanguageRequest batchDetectDominantLanguageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectDominantLanguageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectDominantLanguage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectDominantLanguageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectDominantLanguageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDetectDominantLanguageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse>()
                            .withOperationName("BatchDetectDominantLanguage")
                            .withMarshaller(new BatchDetectDominantLanguageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchDetectDominantLanguageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDetectDominantLanguageRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<BatchDetectDominantLanguageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for named entities and returns information about them. For more
     * information about named entities, see <a>how-entities</a>
     * </p>
     *
     * @param batchDetectEntitiesRequest
     * @return A Java Future containing the result of the BatchDetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectEntitiesResponse> batchDetectEntities(
            BatchDetectEntitiesRequest batchDetectEntitiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDetectEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectEntitiesRequest, BatchDetectEntitiesResponse>()
                            .withOperationName("BatchDetectEntities")
                            .withMarshaller(new BatchDetectEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchDetectEntitiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDetectEntitiesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<BatchDetectEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects the key noun phrases found in a batch of documents.
     * </p>
     *
     * @param batchDetectKeyPhrasesRequest
     * @return A Java Future containing the result of the BatchDetectKeyPhrases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectKeyPhrases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectKeyPhrasesResponse> batchDetectKeyPhrases(
            BatchDetectKeyPhrasesRequest batchDetectKeyPhrasesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectKeyPhrasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectKeyPhrases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectKeyPhrasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectKeyPhrasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDetectKeyPhrasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectKeyPhrasesRequest, BatchDetectKeyPhrasesResponse>()
                            .withOperationName("BatchDetectKeyPhrases")
                            .withMarshaller(new BatchDetectKeyPhrasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchDetectKeyPhrasesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDetectKeyPhrasesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<BatchDetectKeyPhrasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, <code>POSITIVE</code>,
     * <code>NEUTRAL</code>, <code>MIXED</code>, or <code>NEGATIVE</code>, in each one.
     * </p>
     *
     * @param batchDetectSentimentRequest
     * @return A Java Future containing the result of the BatchDetectSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectSentiment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectSentimentResponse> batchDetectSentiment(
            BatchDetectSentimentRequest batchDetectSentimentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectSentimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectSentimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectSentimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDetectSentimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectSentimentRequest, BatchDetectSentimentResponse>()
                            .withOperationName("BatchDetectSentiment")
                            .withMarshaller(new BatchDetectSentimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchDetectSentimentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDetectSentimentRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<BatchDetectSentimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and
     * returns information about them. For more information, see <a>how-syntax</a>.
     * </p>
     *
     * @param batchDetectSyntaxRequest
     * @return A Java Future containing the result of the BatchDetectSyntax operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>BatchSizeLimitExceededException The number of documents in the request exceeds the limit of 25. Try
     *         your request again with fewer documents.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.BatchDetectSyntax
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDetectSyntaxResponse> batchDetectSyntax(BatchDetectSyntaxRequest batchDetectSyntaxRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDetectSyntaxRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDetectSyntax");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDetectSyntaxResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDetectSyntaxResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchDetectSyntaxResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDetectSyntaxRequest, BatchDetectSyntaxResponse>()
                            .withOperationName("BatchDetectSyntax")
                            .withMarshaller(new BatchDetectSyntaxRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(batchDetectSyntaxRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchDetectSyntaxRequest.overrideConfiguration().orElse(null);
            CompletableFuture<BatchDetectSyntaxResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new document classification request to analyze a single document in real-time, using a previously
     * created and trained custom model and an endpoint.
     * </p>
     *
     * @param classifyDocumentRequest
     * @return A Java Future containing the result of the ClassifyDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ClassifyDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ClassifyDocumentResponse> classifyDocument(ClassifyDocumentRequest classifyDocumentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, classifyDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClassifyDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ClassifyDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ClassifyDocumentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ClassifyDocumentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ClassifyDocumentRequest, ClassifyDocumentResponse>()
                            .withOperationName("ClassifyDocument")
                            .withMarshaller(new ClassifyDocumentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(classifyDocumentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = classifyDocumentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ClassifyDocumentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a
     * set of training documents that labeled with the categories that you want to use. After the classifier is trained
     * you can use it to categorize a set of labeled documents into the categories. For more information, see
     * <a>how-document-classification</a>.
     * </p>
     *
     * @param createDocumentClassifierRequest
     * @return A Java Future containing the result of the CreateDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateDocumentClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDocumentClassifierResponse> createDocumentClassifier(
            CreateDocumentClassifierRequest createDocumentClassifierRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentClassifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDocumentClassifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDocumentClassifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDocumentClassifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDocumentClassifierRequest, CreateDocumentClassifierResponse>()
                            .withOperationName("CreateDocumentClassifier")
                            .withMarshaller(new CreateDocumentClassifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDocumentClassifierRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDocumentClassifierRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateDocumentClassifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model
     * </p>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEndpointRequest, CreateEndpointResponse>()
                            .withOperationName("CreateEndpoint")
                            .withMarshaller(new CreateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createEndpointRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an entity recognizer using submitted files. After your <code>CreateEntityRecognizer</code> request is
     * submitted, you can check job status using the API.
     * </p>
     *
     * @param createEntityRecognizerRequest
     * @return A Java Future containing the result of the CreateEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.CreateEntityRecognizer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateEntityRecognizerResponse> createEntityRecognizer(
            CreateEntityRecognizerRequest createEntityRecognizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEntityRecognizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateEntityRecognizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateEntityRecognizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateEntityRecognizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateEntityRecognizerRequest, CreateEntityRecognizerResponse>()
                            .withOperationName("CreateEntityRecognizer")
                            .withMarshaller(new CreateEntityRecognizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createEntityRecognizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createEntityRecognizerRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CreateEntityRecognizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a previously created document classifier
     * </p>
     * <p>
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a
     * background job. Once removed, the classifier disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteDocumentClassifierRequest
     * @return A Java Future containing the result of the DeleteDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteDocumentClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDocumentClassifierResponse> deleteDocumentClassifier(
            DeleteDocumentClassifierRequest deleteDocumentClassifierRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentClassifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDocumentClassifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDocumentClassifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDocumentClassifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDocumentClassifierRequest, DeleteDocumentClassifierResponse>()
                            .withOperationName("DeleteDocumentClassifier")
                            .withMarshaller(new DeleteDocumentClassifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDocumentClassifierRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDocumentClassifierRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteDocumentClassifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order
     * for the model to be deleted.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                            .withOperationName("DeleteEndpoint")
                            .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEndpointRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an entity recognizer.
     * </p>
     * <p>
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference
     * job is using the model, a <code>ResourceInUseException</code> will be returned.
     * </p>
     * <p>
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a
     * background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     * </p>
     *
     * @param deleteEntityRecognizerRequest
     * @return A Java Future containing the result of the DeleteEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DeleteEntityRecognizer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEntityRecognizerResponse> deleteEntityRecognizer(
            DeleteEntityRecognizerRequest deleteEntityRecognizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEntityRecognizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEntityRecognizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEntityRecognizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteEntityRecognizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEntityRecognizerRequest, DeleteEntityRecognizerResponse>()
                            .withOperationName("DeleteEntityRecognizer")
                            .withMarshaller(new DeleteEntityRecognizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteEntityRecognizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteEntityRecognizerRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteEntityRecognizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a document classification job. Use this operation to get the status of a
     * classification job.
     * </p>
     *
     * @param describeDocumentClassificationJobRequest
     * @return A Java Future containing the result of the DescribeDocumentClassificationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDocumentClassificationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDocumentClassificationJobResponse> describeDocumentClassificationJob(
            DescribeDocumentClassificationJobRequest describeDocumentClassificationJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDocumentClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDocumentClassificationJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDocumentClassificationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDocumentClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDocumentClassificationJobRequest, DescribeDocumentClassificationJobResponse>()
                            .withOperationName("DescribeDocumentClassificationJob")
                            .withMarshaller(new DescribeDocumentClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDocumentClassificationJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDocumentClassificationJobRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeDocumentClassificationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a document classifier.
     * </p>
     *
     * @param describeDocumentClassifierRequest
     * @return A Java Future containing the result of the DescribeDocumentClassifier operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDocumentClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDocumentClassifierResponse> describeDocumentClassifier(
            DescribeDocumentClassifierRequest describeDocumentClassifierRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDocumentClassifierRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDocumentClassifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDocumentClassifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDocumentClassifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDocumentClassifierRequest, DescribeDocumentClassifierResponse>()
                            .withOperationName("DescribeDocumentClassifier")
                            .withMarshaller(new DescribeDocumentClassifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDocumentClassifierRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDocumentClassifierRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeDocumentClassifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the DescribeDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeDominantLanguageDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDominantLanguageDetectionJobResponse> describeDominantLanguageDetectionJob(
            DescribeDominantLanguageDetectionJobRequest describeDominantLanguageDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDominantLanguageDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeDominantLanguageDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDominantLanguageDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDominantLanguageDetectionJobRequest, DescribeDominantLanguageDetectionJobResponse>()
                            .withOperationName("DescribeDominantLanguageDetectionJob")
                            .withMarshaller(new DescribeDominantLanguageDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDominantLanguageDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeDominantLanguageDetectionJobRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribeDominantLanguageDetectionJobResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointRequest, DescribeEndpointResponse>()
                            .withOperationName("DescribeEndpoint")
                            .withMarshaller(new DescribeEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEndpointRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the DescribeEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEntitiesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEntitiesDetectionJobResponse> describeEntitiesDetectionJob(
            DescribeEntitiesDetectionJobRequest describeEntitiesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEntitiesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEntitiesDetectionJobRequest, DescribeEntitiesDetectionJobResponse>()
                            .withOperationName("DescribeEntitiesDetectionJob")
                            .withMarshaller(new DescribeEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEntitiesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEntitiesDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer
     * metadata, metrics, and so on.
     * </p>
     *
     * @param describeEntityRecognizerRequest
     * @return A Java Future containing the result of the DescribeEntityRecognizer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEntityRecognizer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEntityRecognizerResponse> describeEntityRecognizer(
            DescribeEntityRecognizerRequest describeEntityRecognizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEntityRecognizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEntityRecognizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEntityRecognizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEntityRecognizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEntityRecognizerRequest, DescribeEntityRecognizerResponse>()
                            .withOperationName("DescribeEntityRecognizer")
                            .withMarshaller(new DescribeEntityRecognizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEntityRecognizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEntityRecognizerRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeEntityRecognizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the status and details of an events detection job.
     * </p>
     *
     * @param describeEventsDetectionJobRequest
     * @return A Java Future containing the result of the DescribeEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeEventsDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventsDetectionJobResponse> describeEventsDetectionJob(
            DescribeEventsDetectionJobRequest describeEventsDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventsDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeEventsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventsDetectionJobRequest, DescribeEventsDetectionJobResponse>()
                            .withOperationName("DescribeEventsDetectionJob")
                            .withMarshaller(new DescribeEventsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeEventsDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeEventsDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeEventsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the DescribeKeyPhrasesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeKeyPhrasesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> describeKeyPhrasesDetectionJob(
            DescribeKeyPhrasesDetectionJobRequest describeKeyPhrasesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeKeyPhrasesDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeKeyPhrasesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeKeyPhrasesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeKeyPhrasesDetectionJobRequest, DescribeKeyPhrasesDetectionJobResponse>()
                            .withOperationName("DescribeKeyPhrasesDetectionJob")
                            .withMarshaller(new DescribeKeyPhrasesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeKeyPhrasesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeKeyPhrasesDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeKeyPhrasesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get
     * the job status.
     * </p>
     *
     * @param describePiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the DescribePiiEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribePiiEntitiesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribePiiEntitiesDetectionJobResponse> describePiiEntitiesDetectionJob(
            DescribePiiEntitiesDetectionJobRequest describePiiEntitiesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePiiEntitiesDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePiiEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePiiEntitiesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePiiEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePiiEntitiesDetectionJobRequest, DescribePiiEntitiesDetectionJobResponse>()
                            .withOperationName("DescribePiiEntitiesDetectionJob")
                            .withMarshaller(new DescribePiiEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describePiiEntitiesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describePiiEntitiesDetectionJobRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DescribePiiEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a
     * detection job.
     * </p>
     *
     * @param describeSentimentDetectionJobRequest
     * @return A Java Future containing the result of the DescribeSentimentDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeSentimentDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSentimentDetectionJobResponse> describeSentimentDetectionJob(
            DescribeSentimentDetectionJobRequest describeSentimentDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeSentimentDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSentimentDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSentimentDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSentimentDetectionJobRequest, DescribeSentimentDetectionJobResponse>()
                            .withOperationName("DescribeSentimentDetectionJob")
                            .withMarshaller(new DescribeSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeSentimentDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeSentimentDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeSentimentDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection
     * job.
     * </p>
     *
     * @param describeTopicsDetectionJobRequest
     * @return A Java Future containing the result of the DescribeTopicsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DescribeTopicsDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTopicsDetectionJobResponse> describeTopicsDetectionJob(
            DescribeTopicsDetectionJobRequest describeTopicsDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTopicsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTopicsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTopicsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTopicsDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTopicsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTopicsDetectionJobRequest, DescribeTopicsDetectionJobResponse>()
                            .withOperationName("DescribeTopicsDetectionJob")
                            .withMarshaller(new DescribeTopicsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTopicsDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeTopicsDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeTopicsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect,
     * see <a href="https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html">Amazon Comprehend Supported
     * Languages</a>.
     * </p>
     *
     * @param detectDominantLanguageRequest
     * @return A Java Future containing the result of the DetectDominantLanguage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectDominantLanguage
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectDominantLanguageResponse> detectDominantLanguage(
            DetectDominantLanguageRequest detectDominantLanguageRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectDominantLanguageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectDominantLanguage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectDominantLanguageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectDominantLanguageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectDominantLanguageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectDominantLanguageRequest, DetectDominantLanguageResponse>()
                            .withOperationName("DetectDominantLanguage")
                            .withMarshaller(new DetectDominantLanguageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectDominantLanguageRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectDominantLanguageRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DetectDominantLanguageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects text for named entities, and returns information about them. For more information, about named entities,
     * see <a>how-entities</a>.
     * </p>
     *
     * @param detectEntitiesRequest
     * @return A Java Future containing the result of the DetectEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetectEntitiesResponse> detectEntities(DetectEntitiesRequest detectEntitiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectEntitiesRequest, DetectEntitiesResponse>()
                            .withOperationName("DetectEntities")
                            .withMarshaller(new DetectEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectEntitiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectEntitiesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DetectEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Detects the key noun phrases found in the text.
     * </p>
     *
     * @param detectKeyPhrasesRequest
     * @return A Java Future containing the result of the DetectKeyPhrases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectKeyPhrases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectKeyPhrasesResponse> detectKeyPhrases(DetectKeyPhrasesRequest detectKeyPhrasesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectKeyPhrasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectKeyPhrases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectKeyPhrasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectKeyPhrasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectKeyPhrasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectKeyPhrasesRequest, DetectKeyPhrasesResponse>()
                            .withOperationName("DetectKeyPhrases")
                            .withMarshaller(new DetectKeyPhrasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectKeyPhrasesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectKeyPhrasesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DetectKeyPhrasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns
     * information about them.
     * </p>
     *
     * @param detectPiiEntitiesRequest
     * @return A Java Future containing the result of the DetectPiiEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectPiiEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DetectPiiEntitiesResponse> detectPiiEntities(DetectPiiEntitiesRequest detectPiiEntitiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectPiiEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectPiiEntities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectPiiEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectPiiEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectPiiEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectPiiEntitiesRequest, DetectPiiEntitiesResponse>()
                            .withOperationName("DetectPiiEntities")
                            .withMarshaller(new DetectPiiEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectPiiEntitiesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectPiiEntitiesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DetectPiiEntitiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects text and returns an inference of the prevailing sentiment (<code>POSITIVE</code>, <code>NEUTRAL</code>,
     * <code>MIXED</code>, or <code>NEGATIVE</code>).
     * </p>
     *
     * @param detectSentimentRequest
     * @return A Java Future containing the result of the DetectSentiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectSentiment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetectSentimentResponse> detectSentiment(DetectSentimentRequest detectSentimentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectSentimentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectSentiment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectSentimentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DetectSentimentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectSentimentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectSentimentRequest, DetectSentimentResponse>()
                            .withOperationName("DetectSentiment")
                            .withMarshaller(new DetectSentimentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectSentimentRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectSentimentRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DetectSentimentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Inspects text for syntax and the part of speech of words in the document. For more information,
     * <a>how-syntax</a>.
     * </p>
     *
     * @param detectSyntaxRequest
     * @return A Java Future containing the result of the DetectSyntax operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TextSizeLimitExceededException The size of the input text exceeds the limit. Use a smaller document.</li>
     *         <li>UnsupportedLanguageException Amazon Comprehend can't process the language of the input text. For all
     *         custom entity recognition APIs (such as <code>CreateEntityRecognizer</code>), only English, Spanish,
     *         French, Italian, German, or Portuguese are accepted. For most other APIs, such as those for Custom
     *         Classification, Amazon Comprehend accepts text in all supported languages. For a list of supported
     *         languages, see <a>supported-languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.DetectSyntax
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DetectSyntaxResponse> detectSyntax(DetectSyntaxRequest detectSyntaxRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detectSyntaxRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetectSyntax");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DetectSyntaxResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DetectSyntaxResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DetectSyntaxResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DetectSyntaxRequest, DetectSyntaxResponse>()
                            .withOperationName("DetectSyntax").withMarshaller(new DetectSyntaxRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(detectSyntaxRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detectSyntaxRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DetectSyntaxResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return A Java Future containing the result of the ListDocumentClassificationJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentClassificationJobsResponse> listDocumentClassificationJobs(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDocumentClassificationJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentClassificationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentClassificationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDocumentClassificationJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDocumentClassificationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentClassificationJobsRequest, ListDocumentClassificationJobsResponse>()
                            .withOperationName("ListDocumentClassificationJobs")
                            .withMarshaller(new ListDocumentClassificationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDocumentClassificationJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDocumentClassificationJobsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListDocumentClassificationJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the documentation classification jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher publisher = client.listDocumentClassificationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassificationJobsPublisher publisher = client.listDocumentClassificationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassificationJobs(software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassificationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassificationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDocumentClassificationJobsPublisher listDocumentClassificationJobsPaginator(
            ListDocumentClassificationJobsRequest listDocumentClassificationJobsRequest) {
        return new ListDocumentClassificationJobsPublisher(this, applyPaginatorUserAgent(listDocumentClassificationJobsRequest));
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return A Java Future containing the result of the ListDocumentClassifiers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDocumentClassifiersResponse> listDocumentClassifiers(
            ListDocumentClassifiersRequest listDocumentClassifiersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentClassifiersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentClassifiers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDocumentClassifiersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDocumentClassifiersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDocumentClassifiersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDocumentClassifiersRequest, ListDocumentClassifiersResponse>()
                            .withOperationName("ListDocumentClassifiers")
                            .withMarshaller(new ListDocumentClassifiersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDocumentClassifiersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDocumentClassifiersRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListDocumentClassifiersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the document classifiers that you have created.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher publisher = client.listDocumentClassifiersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDocumentClassifiersPublisher publisher = client.listDocumentClassifiersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentClassifiers(software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentClassifiersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDocumentClassifiers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDocumentClassifiersPublisher listDocumentClassifiersPaginator(
            ListDocumentClassifiersRequest listDocumentClassifiersRequest) {
        return new ListDocumentClassifiersPublisher(this, applyPaginatorUserAgent(listDocumentClassifiersRequest));
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return A Java Future containing the result of the ListDominantLanguageDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDominantLanguageDetectionJobsResponse> listDominantLanguageDetectionJobs(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDominantLanguageDetectionJobsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDominantLanguageDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDominantLanguageDetectionJobsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListDominantLanguageDetectionJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDominantLanguageDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDominantLanguageDetectionJobsRequest, ListDominantLanguageDetectionJobsResponse>()
                            .withOperationName("ListDominantLanguageDetectionJobs")
                            .withMarshaller(new ListDominantLanguageDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDominantLanguageDetectionJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDominantLanguageDetectionJobsRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListDominantLanguageDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the dominant language detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher publisher = client.listDominantLanguageDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListDominantLanguageDetectionJobsPublisher publisher = client.listDominantLanguageDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDominantLanguageDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDominantLanguageDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListDominantLanguageDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDominantLanguageDetectionJobsPublisher listDominantLanguageDetectionJobsPaginator(
            ListDominantLanguageDetectionJobsRequest listDominantLanguageDetectionJobsRequest) {
        return new ListDominantLanguageDetectionJobsPublisher(this,
                applyPaginatorUserAgent(listDominantLanguageDetectionJobsRequest));
    }

    /**
     * <p>
     * Gets a list of all existing endpoints that you've created.
     * </p>
     *
     * @param listEndpointsRequest
     * @return A Java Future containing the result of the ListEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListEndpointsResponse> listEndpoints(ListEndpointsRequest listEndpointsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEndpointsRequest, ListEndpointsResponse>()
                            .withOperationName("ListEndpoints")
                            .withMarshaller(new ListEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEndpointsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listEndpointsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return A Java Future containing the result of the ListEntitiesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntitiesDetectionJobsResponse> listEntitiesDetectionJobs(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitiesDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntitiesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEntitiesDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEntitiesDetectionJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEntitiesDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntitiesDetectionJobsRequest, ListEntitiesDetectionJobsResponse>()
                            .withOperationName("ListEntitiesDetectionJobs")
                            .withMarshaller(new ListEntitiesDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEntitiesDetectionJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listEntitiesDetectionJobsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListEntitiesDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the entity detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher publisher = client.listEntitiesDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntitiesDetectionJobsPublisher publisher = client.listEntitiesDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntitiesDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListEntitiesDetectionJobsPublisher listEntitiesDetectionJobsPaginator(
            ListEntitiesDetectionJobsRequest listEntitiesDetectionJobsRequest) {
        return new ListEntitiesDetectionJobsPublisher(this, applyPaginatorUserAgent(listEntitiesDetectionJobsRequest));
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return A Java Future containing the result of the ListEntityRecognizers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEntityRecognizersResponse> listEntityRecognizers(
            ListEntityRecognizersRequest listEntityRecognizersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntityRecognizersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntityRecognizers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEntityRecognizersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEntityRecognizersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEntityRecognizersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEntityRecognizersRequest, ListEntityRecognizersResponse>()
                            .withOperationName("ListEntityRecognizers")
                            .withMarshaller(new ListEntityRecognizersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEntityRecognizersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listEntityRecognizersRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListEntityRecognizersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in
     * training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This
     * call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     * </p>
     * <p>
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher publisher = client.listEntityRecognizersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEntityRecognizersPublisher publisher = client.listEntityRecognizersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntityRecognizers(software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntityRecognizersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEntityRecognizers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers"
     *      target="_top">AWS API Documentation</a>
     */
    public ListEntityRecognizersPublisher listEntityRecognizersPaginator(ListEntityRecognizersRequest listEntityRecognizersRequest) {
        return new ListEntityRecognizersPublisher(this, applyPaginatorUserAgent(listEntityRecognizersRequest));
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return A Java Future containing the result of the ListEventsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEventsDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListEventsDetectionJobsResponse> listEventsDetectionJobs(
            ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventsDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventsDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListEventsDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListEventsDetectionJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListEventsDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListEventsDetectionJobsRequest, ListEventsDetectionJobsResponse>()
                            .withOperationName("ListEventsDetectionJobs")
                            .withMarshaller(new ListEventsDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listEventsDetectionJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listEventsDetectionJobsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListEventsDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the events detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsPublisher publisher = client.listEventsDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListEventsDetectionJobsPublisher publisher = client.listEventsDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventsDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListEventsDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEventsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListEventsDetectionJobsPublisher listEventsDetectionJobsPaginator(
            ListEventsDetectionJobsRequest listEventsDetectionJobsRequest) {
        return new ListEventsDetectionJobsPublisher(this, applyPaginatorUserAgent(listEventsDetectionJobsRequest));
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return A Java Future containing the result of the ListKeyPhrasesDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListKeyPhrasesDetectionJobsResponse> listKeyPhrasesDetectionJobs(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listKeyPhrasesDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListKeyPhrasesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListKeyPhrasesDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListKeyPhrasesDetectionJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListKeyPhrasesDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListKeyPhrasesDetectionJobsRequest, ListKeyPhrasesDetectionJobsResponse>()
                            .withOperationName("ListKeyPhrasesDetectionJobs")
                            .withMarshaller(new ListKeyPhrasesDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listKeyPhrasesDetectionJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listKeyPhrasesDetectionJobsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListKeyPhrasesDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get a list of key phrase detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher publisher = client.listKeyPhrasesDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListKeyPhrasesDetectionJobsPublisher publisher = client.listKeyPhrasesDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listKeyPhrasesDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listKeyPhrasesDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListKeyPhrasesDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListKeyPhrasesDetectionJobsPublisher listKeyPhrasesDetectionJobsPaginator(
            ListKeyPhrasesDetectionJobsRequest listKeyPhrasesDetectionJobsRequest) {
        return new ListKeyPhrasesDetectionJobsPublisher(this, applyPaginatorUserAgent(listKeyPhrasesDetectionJobsRequest));
    }

    /**
     * <p>
     * Gets a list of the PII entity detection jobs that you have submitted.
     * </p>
     *
     * @param listPiiEntitiesDetectionJobsRequest
     * @return A Java Future containing the result of the ListPiiEntitiesDetectionJobs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListPiiEntitiesDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPiiEntitiesDetectionJobsResponse> listPiiEntitiesDetectionJobs(
            ListPiiEntitiesDetectionJobsRequest listPiiEntitiesDetectionJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPiiEntitiesDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPiiEntitiesDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPiiEntitiesDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPiiEntitiesDetectionJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPiiEntitiesDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPiiEntitiesDetectionJobsRequest, ListPiiEntitiesDetectionJobsResponse>()
                            .withOperationName("ListPiiEntitiesDetectionJobs")
                            .withMarshaller(new ListPiiEntitiesDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPiiEntitiesDetectionJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPiiEntitiesDetectionJobsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListPiiEntitiesDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return A Java Future containing the result of the ListSentimentDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSentimentDetectionJobsResponse> listSentimentDetectionJobs(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSentimentDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSentimentDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSentimentDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSentimentDetectionJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSentimentDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSentimentDetectionJobsRequest, ListSentimentDetectionJobsResponse>()
                            .withOperationName("ListSentimentDetectionJobs")
                            .withMarshaller(new ListSentimentDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSentimentDetectionJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listSentimentDetectionJobsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListSentimentDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of sentiment detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher publisher = client.listSentimentDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListSentimentDetectionJobsPublisher publisher = client.listSentimentDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSentimentDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSentimentDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListSentimentDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListSentimentDetectionJobsPublisher listSentimentDetectionJobsPaginator(
            ListSentimentDetectionJobsRequest listSentimentDetectionJobsRequest) {
        return new ListSentimentDetectionJobsPublisher(this, applyPaginatorUserAgent(listSentimentDetectionJobsRequest));
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Comprehend resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return A Java Future containing the result of the ListTopicsDetectionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTopicsDetectionJobsResponse> listTopicsDetectionJobs(
            ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTopicsDetectionJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTopicsDetectionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTopicsDetectionJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTopicsDetectionJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTopicsDetectionJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTopicsDetectionJobsRequest, ListTopicsDetectionJobsResponse>()
                            .withOperationName("ListTopicsDetectionJobs")
                            .withMarshaller(new ListTopicsDetectionJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTopicsDetectionJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTopicsDetectionJobsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListTopicsDetectionJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the topic detection jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher publisher = client.listTopicsDetectionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.comprehend.paginators.ListTopicsDetectionJobsPublisher publisher = client.listTopicsDetectionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopicsDetectionJobs(software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTopicsDetectionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>InvalidFilterException The filter specified for the operation is invalid. Specify a different filter.
     *         </li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.ListTopicsDetectionJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTopicsDetectionJobsPublisher listTopicsDetectionJobsPaginator(
            ListTopicsDetectionJobsRequest listTopicsDetectionJobsRequest) {
        return new ListTopicsDetectionJobsPublisher(this, applyPaginatorUserAgent(listTopicsDetectionJobsRequest));
    }

    /**
     * <p>
     * Starts an asynchronous document classification job. Use the operation to track the progress of the job.
     * </p>
     *
     * @param startDocumentClassificationJobRequest
     * @return A Java Future containing the result of the StartDocumentClassificationJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartDocumentClassificationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDocumentClassificationJobResponse> startDocumentClassificationJob(
            StartDocumentClassificationJobRequest startDocumentClassificationJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startDocumentClassificationJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDocumentClassificationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDocumentClassificationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartDocumentClassificationJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartDocumentClassificationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDocumentClassificationJobRequest, StartDocumentClassificationJobResponse>()
                            .withOperationName("StartDocumentClassificationJob")
                            .withMarshaller(new StartDocumentClassificationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startDocumentClassificationJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startDocumentClassificationJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartDocumentClassificationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track
     * the status of a job.
     * </p>
     *
     * @param startDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the StartDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartDominantLanguageDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartDominantLanguageDetectionJobResponse> startDominantLanguageDetectionJob(
            StartDominantLanguageDetectionJobRequest startDominantLanguageDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDominantLanguageDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartDominantLanguageDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartDominantLanguageDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDominantLanguageDetectionJobRequest, StartDominantLanguageDetectionJobResponse>()
                            .withOperationName("StartDominantLanguageDetectionJob")
                            .withMarshaller(new StartDominantLanguageDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startDominantLanguageDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startDominantLanguageDetectionJobRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<StartDominantLanguageDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status
     * of a job.
     * </p>
     * <p>
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for
     * custom entity recognition, the optional <code>EntityRecognizerArn</code> must be used in order to provide access
     * to the recognizer being used to detect the custom entity.
     * </p>
     *
     * @param startEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StartEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartEntitiesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartEntitiesDetectionJobResponse> startEntitiesDetectionJob(
            StartEntitiesDetectionJobRequest startEntitiesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartEntitiesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartEntitiesDetectionJobRequest, StartEntitiesDetectionJobResponse>()
                            .withOperationName("StartEntitiesDetectionJob")
                            .withMarshaller(new StartEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startEntitiesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startEntitiesDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous event detection job for a collection of documents.
     * </p>
     *
     * @param startEventsDetectionJobRequest
     * @return A Java Future containing the result of the StartEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartEventsDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartEventsDetectionJobResponse> startEventsDetectionJob(
            StartEventsDetectionJobRequest startEventsDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startEventsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartEventsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartEventsDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartEventsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartEventsDetectionJobRequest, StartEventsDetectionJobResponse>()
                            .withOperationName("StartEventsDetectionJob")
                            .withMarshaller(new StartEventsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startEventsDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startEventsDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartEventsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the StartKeyPhrasesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartKeyPhrasesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartKeyPhrasesDetectionJobResponse> startKeyPhrasesDetectionJob(
            StartKeyPhrasesDetectionJobRequest startKeyPhrasesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startKeyPhrasesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartKeyPhrasesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartKeyPhrasesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartKeyPhrasesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartKeyPhrasesDetectionJobRequest, StartKeyPhrasesDetectionJobResponse>()
                            .withOperationName("StartKeyPhrasesDetectionJob")
                            .withMarshaller(new StartKeyPhrasesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startKeyPhrasesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startKeyPhrasesDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartKeyPhrasesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous PII entity detection job for a collection of documents.
     * </p>
     *
     * @param startPiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StartPiiEntitiesDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartPiiEntitiesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartPiiEntitiesDetectionJobResponse> startPiiEntitiesDetectionJob(
            StartPiiEntitiesDetectionJobRequest startPiiEntitiesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startPiiEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartPiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartPiiEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartPiiEntitiesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartPiiEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartPiiEntitiesDetectionJobRequest, StartPiiEntitiesDetectionJobResponse>()
                            .withOperationName("StartPiiEntitiesDetectionJob")
                            .withMarshaller(new StartPiiEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startPiiEntitiesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startPiiEntitiesDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartPiiEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous sentiment detection job for a collection of documents. use the operation to track the
     * status of a job.
     * </p>
     *
     * @param startSentimentDetectionJobRequest
     * @return A Java Future containing the result of the StartSentimentDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartSentimentDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartSentimentDetectionJobResponse> startSentimentDetectionJob(
            StartSentimentDetectionJobRequest startSentimentDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSentimentDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartSentimentDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartSentimentDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartSentimentDetectionJobRequest, StartSentimentDetectionJobResponse>()
                            .withOperationName("StartSentimentDetectionJob")
                            .withMarshaller(new StartSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startSentimentDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startSentimentDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartSentimentDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an asynchronous topic detection job. Use the <code>DescribeTopicDetectionJob</code> operation to track the
     * status of a job.
     * </p>
     *
     * @param startTopicsDetectionJobRequest
     * @return A Java Future containing the result of the StartTopicsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>KmsKeyValidationException The KMS customer managed key (CMK) entered cannot be validated. Verify the
     *         key and re-enter it.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StartTopicsDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartTopicsDetectionJobResponse> startTopicsDetectionJob(
            StartTopicsDetectionJobRequest startTopicsDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startTopicsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartTopicsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartTopicsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartTopicsDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartTopicsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartTopicsDetectionJobRequest, StartTopicsDetectionJobResponse>()
                            .withOperationName("StartTopicsDetectionJob")
                            .withMarshaller(new StartTopicsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startTopicsDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startTopicsDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StartTopicsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a dominant language detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopDominantLanguageDetectionJobRequest
     * @return A Java Future containing the result of the StopDominantLanguageDetectionJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopDominantLanguageDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopDominantLanguageDetectionJobResponse> stopDominantLanguageDetectionJob(
            StopDominantLanguageDetectionJobRequest stopDominantLanguageDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                stopDominantLanguageDetectionJobRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDominantLanguageDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopDominantLanguageDetectionJobResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StopDominantLanguageDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopDominantLanguageDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDominantLanguageDetectionJobRequest, StopDominantLanguageDetectionJobResponse>()
                            .withOperationName("StopDominantLanguageDetectionJob")
                            .withMarshaller(new StopDominantLanguageDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopDominantLanguageDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopDominantLanguageDetectionJobRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<StopDominantLanguageDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an entities detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StopEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopEntitiesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopEntitiesDetectionJobResponse> stopEntitiesDetectionJob(
            StopEntitiesDetectionJobRequest stopEntitiesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopEntitiesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopEntitiesDetectionJobRequest, StopEntitiesDetectionJobResponse>()
                            .withOperationName("StopEntitiesDetectionJob")
                            .withMarshaller(new StopEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopEntitiesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopEntitiesDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StopEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an events detection job in progress.
     * </p>
     *
     * @param stopEventsDetectionJobRequest
     * @return A Java Future containing the result of the StopEventsDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopEventsDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEventsDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopEventsDetectionJobResponse> stopEventsDetectionJob(
            StopEventsDetectionJobRequest stopEventsDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopEventsDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopEventsDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopEventsDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopEventsDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopEventsDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopEventsDetectionJobRequest, StopEventsDetectionJobResponse>()
                            .withOperationName("StopEventsDetectionJob")
                            .withMarshaller(new StopEventsDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopEventsDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopEventsDetectionJobRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<StopEventsDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a key phrases detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopKeyPhrasesDetectionJobRequest
     * @return A Java Future containing the result of the StopKeyPhrasesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopKeyPhrasesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopKeyPhrasesDetectionJobResponse> stopKeyPhrasesDetectionJob(
            StopKeyPhrasesDetectionJobRequest stopKeyPhrasesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopKeyPhrasesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopKeyPhrasesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopKeyPhrasesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopKeyPhrasesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopKeyPhrasesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopKeyPhrasesDetectionJobRequest, StopKeyPhrasesDetectionJobResponse>()
                            .withOperationName("StopKeyPhrasesDetectionJob")
                            .withMarshaller(new StopKeyPhrasesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopKeyPhrasesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopKeyPhrasesDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StopKeyPhrasesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a PII entities detection job in progress.
     * </p>
     *
     * @param stopPiiEntitiesDetectionJobRequest
     * @return A Java Future containing the result of the StopPiiEntitiesDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopPiiEntitiesDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopPiiEntitiesDetectionJobResponse> stopPiiEntitiesDetectionJob(
            StopPiiEntitiesDetectionJobRequest stopPiiEntitiesDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopPiiEntitiesDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopPiiEntitiesDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopPiiEntitiesDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopPiiEntitiesDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopPiiEntitiesDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopPiiEntitiesDetectionJobRequest, StopPiiEntitiesDetectionJobResponse>()
                            .withOperationName("StopPiiEntitiesDetectionJob")
                            .withMarshaller(new StopPiiEntitiesDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopPiiEntitiesDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopPiiEntitiesDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StopPiiEntitiesDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a sentiment detection job in progress.
     * </p>
     * <p>
     * If the job state is <code>IN_PROGRESS</code> the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state; otherwise the job is be stopped and put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * If the job is in the <code>COMPLETED</code> or <code>FAILED</code> state when you call the
     * <code>StopDominantLanguageDetectionJob</code> operation, the operation returns a 400 Internal Request Exception.
     * </p>
     * <p>
     * When a job is stopped, any documents already processed are written to the output location.
     * </p>
     *
     * @param stopSentimentDetectionJobRequest
     * @return A Java Future containing the result of the StopSentimentDetectionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>JobNotFoundException The specified job was not found. Check the job ID and try again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopSentimentDetectionJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopSentimentDetectionJobResponse> stopSentimentDetectionJob(
            StopSentimentDetectionJobRequest stopSentimentDetectionJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopSentimentDetectionJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopSentimentDetectionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopSentimentDetectionJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopSentimentDetectionJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopSentimentDetectionJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopSentimentDetectionJobRequest, StopSentimentDetectionJobResponse>()
                            .withOperationName("StopSentimentDetectionJob")
                            .withMarshaller(new StopSentimentDetectionJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopSentimentDetectionJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopSentimentDetectionJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StopSentimentDetectionJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops a document classifier training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and put into the <code>STOPPED</code> state and the
     * service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingDocumentClassifierRequest
     * @return A Java Future containing the result of the StopTrainingDocumentClassifier operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTrainingDocumentClassifier
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopTrainingDocumentClassifierResponse> stopTrainingDocumentClassifier(
            StopTrainingDocumentClassifierRequest stopTrainingDocumentClassifierRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                stopTrainingDocumentClassifierRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopTrainingDocumentClassifier");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopTrainingDocumentClassifierResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopTrainingDocumentClassifierResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopTrainingDocumentClassifierResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopTrainingDocumentClassifierRequest, StopTrainingDocumentClassifierResponse>()
                            .withOperationName("StopTrainingDocumentClassifier")
                            .withMarshaller(new StopTrainingDocumentClassifierRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopTrainingDocumentClassifierRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopTrainingDocumentClassifierRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StopTrainingDocumentClassifierResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops an entity recognizer training job while in progress.
     * </p>
     * <p>
     * If the training job state is <code>TRAINING</code>, the job is marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the training job completes before it can be stopped, it is put into the
     * <code>TRAINED</code>; otherwise the training job is stopped and putted into the <code>STOPPED</code> state and
     * the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param stopTrainingEntityRecognizerRequest
     * @return A Java Future containing the result of the StopTrainingEntityRecognizer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.StopTrainingEntityRecognizer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StopTrainingEntityRecognizerResponse> stopTrainingEntityRecognizer(
            StopTrainingEntityRecognizerRequest stopTrainingEntityRecognizerRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopTrainingEntityRecognizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopTrainingEntityRecognizer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopTrainingEntityRecognizerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopTrainingEntityRecognizerResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopTrainingEntityRecognizerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopTrainingEntityRecognizerRequest, StopTrainingEntityRecognizerResponse>()
                            .withOperationName("StopTrainingEntityRecognizer")
                            .withMarshaller(new StopTrainingEntityRecognizerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopTrainingEntityRecognizerRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = stopTrainingEntityRecognizerRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<StopTrainingEntityRecognizerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ConcurrentModificationException Concurrent modification of the tags associated with an Amazon
     *         Comprehend resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>TooManyTagsException The request contains more tags than can be associated with a resource (50 tags
     *         per resource). The maximum number of tags includes both existing tags and those included in your current
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Comprehend resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyTagKeysException The request contains more tag keys than can be associated with a resource (50
     *         tag keys per resource).</li>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>ConcurrentModificationException Concurrent modification of the tags associated with an Amazon
     *         Comprehend resource is not supported.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information about the specified endpoint.
     * </p>
     *
     * @param updateEndpointRequest
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is invalid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit. Resubmit your request later.</li>
     *         <li>ResourceInUseException The specified resource name is already in use. Use a different name and try
     *         your request again.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources per account has been exceeded. Review
     *         the resources, and then try your request again.</li>
     *         <li>ResourceNotFoundException The specified resource ARN was not found. Check the ARN and try your
     *         request again.</li>
     *         <li>ResourceUnavailableException The specified resource is not available. Check the resource and try your
     *         request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ComprehendException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ComprehendAsyncClient.UpdateEndpoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Comprehend");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateEndpointRequest, UpdateEndpointResponse>()
                            .withOperationName("UpdateEndpoint")
                            .withMarshaller(new UpdateEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateEndpointRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateEndpointRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ComprehendException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KmsKeyValidationException")
                                .exceptionBuilderSupplier(KmsKeyValidationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilterException")
                                .exceptionBuilderSupplier(InvalidFilterException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagKeysException")
                                .exceptionBuilderSupplier(TooManyTagKeysException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedLanguageException")
                                .exceptionBuilderSupplier(UnsupportedLanguageException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceUnavailableException")
                                .exceptionBuilderSupplier(ResourceUnavailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                                .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BatchSizeLimitExceededException")
                                .exceptionBuilderSupplier(BatchSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TextSizeLimitExceededException")
                                .exceptionBuilderSupplier(TextSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("JobNotFoundException")
                                .exceptionBuilderSupplier(JobNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends ComprehendRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
