/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.EndpointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointProperties> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(EndpointProperties.getter(EndpointProperties::endpointArn)).setter(EndpointProperties.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EndpointProperties.getter(EndpointProperties::statusAsString)).setter(EndpointProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(EndpointProperties.getter(EndpointProperties::message)).setter(EndpointProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(EndpointProperties.getter(EndpointProperties::modelArn)).setter(EndpointProperties.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<Integer> DESIRED_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DesiredInferenceUnits").getter(EndpointProperties.getter(EndpointProperties::desiredInferenceUnits)).setter(EndpointProperties.setter(Builder::desiredInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInferenceUnits").build()}).build();
    private static final SdkField<Integer> CURRENT_INFERENCE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentInferenceUnits").getter(EndpointProperties.getter(EndpointProperties::currentInferenceUnits)).setter(EndpointProperties.setter(Builder::currentInferenceUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInferenceUnits").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(EndpointProperties.getter(EndpointProperties::creationTime)).setter(EndpointProperties.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(EndpointProperties.getter(EndpointProperties::lastModifiedTime)).setter(EndpointProperties.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD, STATUS_FIELD, MESSAGE_FIELD, MODEL_ARN_FIELD, DESIRED_INFERENCE_UNITS_FIELD, CURRENT_INFERENCE_UNITS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointArn;
    private final String status;
    private final String message;
    private final String modelArn;
    private final Integer desiredInferenceUnits;
    private final Integer currentInferenceUnits;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private EndpointProperties(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.status = builder.status;
        this.message = builder.message;
        this.modelArn = builder.modelArn;
        this.desiredInferenceUnits = builder.desiredInferenceUnits;
        this.currentInferenceUnits = builder.currentInferenceUnits;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final EndpointStatus status() {
        return EndpointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Integer desiredInferenceUnits() {
        return this.desiredInferenceUnits;
    }

    public final Integer currentInferenceUnits() {
        return this.currentInferenceUnits;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInferenceUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointProperties)) {
            return false;
        }
        EndpointProperties other = (EndpointProperties)obj;
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.desiredInferenceUnits(), other.desiredInferenceUnits()) && Objects.equals(this.currentInferenceUnits(), other.currentInferenceUnits()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointProperties").add("EndpointArn", (Object)this.endpointArn()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("ModelArn", (Object)this.modelArn()).add("DesiredInferenceUnits", (Object)this.desiredInferenceUnits()).add("CurrentInferenceUnits", (Object)this.currentInferenceUnits()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "DesiredInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.desiredInferenceUnits()));
            }
            case "CurrentInferenceUnits": {
                return Optional.ofNullable(clazz.cast(this.currentInferenceUnits()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointProperties, T> g) {
        return obj -> g.apply((EndpointProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointArn;
        private String status;
        private String message;
        private String modelArn;
        private Integer desiredInferenceUnits;
        private Integer currentInferenceUnits;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointProperties model) {
            this.endpointArn(model.endpointArn);
            this.status(model.status);
            this.message(model.message);
            this.modelArn(model.modelArn);
            this.desiredInferenceUnits(model.desiredInferenceUnits);
            this.currentInferenceUnits(model.currentInferenceUnits);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        public final Integer getDesiredInferenceUnits() {
            return this.desiredInferenceUnits;
        }

        @Override
        public final Builder desiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
            return this;
        }

        public final void setDesiredInferenceUnits(Integer desiredInferenceUnits) {
            this.desiredInferenceUnits = desiredInferenceUnits;
        }

        public final Integer getCurrentInferenceUnits() {
            return this.currentInferenceUnits;
        }

        @Override
        public final Builder currentInferenceUnits(Integer currentInferenceUnits) {
            this.currentInferenceUnits = currentInferenceUnits;
            return this;
        }

        public final void setCurrentInferenceUnits(Integer currentInferenceUnits) {
            this.currentInferenceUnits = currentInferenceUnits;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public EndpointProperties build() {
            return new EndpointProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointProperties> {
        public Builder endpointArn(String var1);

        public Builder status(String var1);

        public Builder status(EndpointStatus var1);

        public Builder message(String var1);

        public Builder modelArn(String var1);

        public Builder desiredInferenceUnits(Integer var1);

        public Builder currentInferenceUnits(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

