/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTopicsDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListTopicsDetectionJobsResponse> {
    private static final SdkField<List<TopicsDetectionJobProperties>> TOPICS_DETECTION_JOB_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TopicsDetectionJobPropertiesList").getter(ListTopicsDetectionJobsResponse.getter(ListTopicsDetectionJobsResponse::topicsDetectionJobPropertiesList)).setter(ListTopicsDetectionJobsResponse.setter(Builder::topicsDetectionJobPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicsDetectionJobPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicsDetectionJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTopicsDetectionJobsResponse.getter(ListTopicsDetectionJobsResponse::nextToken)).setter(ListTopicsDetectionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPICS_DETECTION_JOB_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList;
    private final String nextToken;

    private ListTopicsDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.topicsDetectionJobPropertiesList = builder.topicsDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTopicsDetectionJobPropertiesList() {
        return this.topicsDetectionJobPropertiesList != null && !(this.topicsDetectionJobPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList() {
        return this.topicsDetectionJobPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopicsDetectionJobPropertiesList() ? this.topicsDetectionJobPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsDetectionJobsResponse)) {
            return false;
        }
        ListTopicsDetectionJobsResponse other = (ListTopicsDetectionJobsResponse)((Object)obj);
        return this.hasTopicsDetectionJobPropertiesList() == other.hasTopicsDetectionJobPropertiesList() && Objects.equals(this.topicsDetectionJobPropertiesList(), other.topicsDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTopicsDetectionJobsResponse").add("TopicsDetectionJobPropertiesList", this.hasTopicsDetectionJobPropertiesList() ? this.topicsDetectionJobPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicsDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.topicsDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTopicsDetectionJobsResponse, T> g) {
        return obj -> g.apply((ListTopicsDetectionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsDetectionJobsResponse model) {
            super(model);
            this.topicsDetectionJobPropertiesList(model.topicsDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<TopicsDetectionJobProperties.Builder> getTopicsDetectionJobPropertiesList() {
            if (this.topicsDetectionJobPropertiesList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.topicsDetectionJobPropertiesList != null ? (Collection)this.topicsDetectionJobPropertiesList.stream().map(TopicsDetectionJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topicsDetectionJobPropertiesList(Collection<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList = TopicsDetectionJobPropertiesListCopier.copy(topicsDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsDetectionJobPropertiesList(TopicsDetectionJobProperties ... topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList(Arrays.asList(topicsDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsDetectionJobPropertiesList(Consumer<TopicsDetectionJobProperties.Builder> ... topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList(Stream.of(topicsDetectionJobPropertiesList).map(c -> (TopicsDetectionJobProperties)((TopicsDetectionJobProperties.Builder)TopicsDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopicsDetectionJobPropertiesList(Collection<TopicsDetectionJobProperties.BuilderImpl> topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList = TopicsDetectionJobPropertiesListCopier.copyFromBuilder(topicsDetectionJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTopicsDetectionJobsResponse build() {
            return new ListTopicsDetectionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTopicsDetectionJobsResponse> {
        public Builder topicsDetectionJobPropertiesList(Collection<TopicsDetectionJobProperties> var1);

        public Builder topicsDetectionJobPropertiesList(TopicsDetectionJobProperties ... var1);

        public Builder topicsDetectionJobPropertiesList(Consumer<TopicsDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

