/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.DominantLanguage;
import software.amazon.awssdk.services.comprehend.model.ListOfDominantLanguagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectDominantLanguageItemResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDetectDominantLanguageItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BatchDetectDominantLanguageItemResult.getter(BatchDetectDominantLanguageItemResult::index)).setter(BatchDetectDominantLanguageItemResult.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<List<DominantLanguage>> LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDetectDominantLanguageItemResult.getter(BatchDetectDominantLanguageItemResult::languages)).setter(BatchDetectDominantLanguageItemResult.setter(Builder::languages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DominantLanguage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, LANGUAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final List<DominantLanguage> languages;

    private BatchDetectDominantLanguageItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.languages = builder.languages;
    }

    public Integer index() {
        return this.index;
    }

    public boolean hasLanguages() {
        return this.languages != null && !(this.languages instanceof SdkAutoConstructList);
    }

    public List<DominantLanguage> languages() {
        return this.languages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.languages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectDominantLanguageItemResult)) {
            return false;
        }
        BatchDetectDominantLanguageItemResult other = (BatchDetectDominantLanguageItemResult)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.languages(), other.languages());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectDominantLanguageItemResult").add("Index", (Object)this.index()).add("Languages", this.languages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "Languages": {
                return Optional.ofNullable(clazz.cast(this.languages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectDominantLanguageItemResult, T> g) {
        return obj -> g.apply((BatchDetectDominantLanguageItemResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private List<DominantLanguage> languages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectDominantLanguageItemResult model) {
            this.index(model.index);
            this.languages(model.languages);
        }

        public final Integer getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final Collection<DominantLanguage.Builder> getLanguages() {
            return this.languages != null ? (Collection)this.languages.stream().map(DominantLanguage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder languages(Collection<DominantLanguage> languages) {
            this.languages = ListOfDominantLanguagesCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(DominantLanguage ... languages) {
            this.languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<DominantLanguage.Builder> ... languages) {
            this.languages(Stream.of(languages).map(c -> (DominantLanguage)((DominantLanguage.Builder)DominantLanguage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLanguages(Collection<DominantLanguage.BuilderImpl> languages) {
            this.languages = ListOfDominantLanguagesCopier.copyFromBuilder(languages);
        }

        public BatchDetectDominantLanguageItemResult build() {
            return new BatchDetectDominantLanguageItemResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDetectDominantLanguageItemResult> {
        public Builder index(Integer var1);

        public Builder languages(Collection<DominantLanguage> var1);

        public Builder languages(DominantLanguage ... var1);

        public Builder languages(Consumer<DominantLanguage.Builder> ... var1);
    }
}

