/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEntityRecognizerResponse extends ComprehendResponse implements
        ToCopyableBuilder<CreateEntityRecognizerResponse.Builder, CreateEntityRecognizerResponse> {
    private static final SdkField<String> ENTITY_RECOGNIZER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEntityRecognizerResponse::entityRecognizerArn)).setter(setter(Builder::entityRecognizerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_RECOGNIZER_ARN_FIELD));

    private final String entityRecognizerArn;

    private CreateEntityRecognizerResponse(BuilderImpl builder) {
        super(builder);
        this.entityRecognizerArn = builder.entityRecognizerArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the entity recognizer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the entity recognizer.
     */
    public String entityRecognizerArn() {
        return entityRecognizerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityRecognizerArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEntityRecognizerResponse)) {
            return false;
        }
        CreateEntityRecognizerResponse other = (CreateEntityRecognizerResponse) obj;
        return Objects.equals(entityRecognizerArn(), other.entityRecognizerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateEntityRecognizerResponse").add("EntityRecognizerArn", entityRecognizerArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityRecognizerArn":
            return Optional.ofNullable(clazz.cast(entityRecognizerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEntityRecognizerResponse, T> g) {
        return obj -> g.apply((CreateEntityRecognizerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEntityRecognizerResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the entity recognizer.
         * </p>
         * 
         * @param entityRecognizerArn
         *        The Amazon Resource Name (ARN) that identifies the entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRecognizerArn(String entityRecognizerArn);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private String entityRecognizerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEntityRecognizerResponse model) {
            super(model);
            entityRecognizerArn(model.entityRecognizerArn);
        }

        public final String getEntityRecognizerArn() {
            return entityRecognizerArn;
        }

        @Override
        public final Builder entityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
            return this;
        }

        public final void setEntityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
        }

        @Override
        public CreateEntityRecognizerResponse build() {
            return new CreateEntityRecognizerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
