/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ClassifierMetadata;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierInputDataConfig;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierMode;
import software.amazon.awssdk.services.comprehend.model.DocumentClassifierOutputDataConfig;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.services.comprehend.model.ModelStatus;
import software.amazon.awssdk.services.comprehend.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentClassifierProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentClassifierProperties> {
    private static final SdkField<String> DOCUMENT_CLASSIFIER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::documentClassifierArn)).setter(DocumentClassifierProperties.setter(Builder::documentClassifierArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassifierArn").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::languageCodeAsString)).setter(DocumentClassifierProperties.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::statusAsString)).setter(DocumentClassifierProperties.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::message)).setter(DocumentClassifierProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::submitTime)).setter(DocumentClassifierProperties.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::endTime)).setter(DocumentClassifierProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> TRAINING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::trainingStartTime)).setter(DocumentClassifierProperties.setter(Builder::trainingStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::trainingEndTime)).setter(DocumentClassifierProperties.setter(Builder::trainingEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()}).build();
    private static final SdkField<DocumentClassifierInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::inputDataConfig)).setter(DocumentClassifierProperties.setter(Builder::inputDataConfig)).constructor(DocumentClassifierInputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<DocumentClassifierOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::outputDataConfig)).setter(DocumentClassifierProperties.setter(Builder::outputDataConfig)).constructor(DocumentClassifierOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<ClassifierMetadata> CLASSIFIER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::classifierMetadata)).setter(DocumentClassifierProperties.setter(Builder::classifierMetadata)).constructor(ClassifierMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassifierMetadata").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::dataAccessRoleArn)).setter(DocumentClassifierProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::volumeKmsKeyId)).setter(DocumentClassifierProperties.setter(Builder::volumeKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::vpcConfig)).setter(DocumentClassifierProperties.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentClassifierProperties.getter(DocumentClassifierProperties::modeAsString)).setter(DocumentClassifierProperties.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_CLASSIFIER_ARN_FIELD, LANGUAGE_CODE_FIELD, STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, TRAINING_START_TIME_FIELD, TRAINING_END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, CLASSIFIER_METADATA_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, VOLUME_KMS_KEY_ID_FIELD, VPC_CONFIG_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String documentClassifierArn;
    private final String languageCode;
    private final String status;
    private final String message;
    private final Instant submitTime;
    private final Instant endTime;
    private final Instant trainingStartTime;
    private final Instant trainingEndTime;
    private final DocumentClassifierInputDataConfig inputDataConfig;
    private final DocumentClassifierOutputDataConfig outputDataConfig;
    private final ClassifierMetadata classifierMetadata;
    private final String dataAccessRoleArn;
    private final String volumeKmsKeyId;
    private final VpcConfig vpcConfig;
    private final String mode;

    private DocumentClassifierProperties(BuilderImpl builder) {
        this.documentClassifierArn = builder.documentClassifierArn;
        this.languageCode = builder.languageCode;
        this.status = builder.status;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.trainingStartTime = builder.trainingStartTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.classifierMetadata = builder.classifierMetadata;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.vpcConfig = builder.vpcConfig;
        this.mode = builder.mode;
    }

    public String documentClassifierArn() {
        return this.documentClassifierArn;
    }

    public LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public String languageCodeAsString() {
        return this.languageCode;
    }

    public ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Instant submitTime() {
        return this.submitTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Instant trainingStartTime() {
        return this.trainingStartTime;
    }

    public Instant trainingEndTime() {
        return this.trainingEndTime;
    }

    public DocumentClassifierInputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public DocumentClassifierOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public ClassifierMetadata classifierMetadata() {
        return this.classifierMetadata;
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public String volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public DocumentClassifierMode mode() {
        return DocumentClassifierMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentClassifierArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.classifierMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassifierProperties)) {
            return false;
        }
        DocumentClassifierProperties other = (DocumentClassifierProperties)obj;
        return Objects.equals(this.documentClassifierArn(), other.documentClassifierArn()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.trainingStartTime(), other.trainingStartTime()) && Objects.equals(this.trainingEndTime(), other.trainingEndTime()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.classifierMetadata(), other.classifierMetadata()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && Objects.equals(this.volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public String toString() {
        return ToString.builder((String)"DocumentClassifierProperties").add("DocumentClassifierArn", (Object)this.documentClassifierArn()).add("LanguageCode", (Object)this.languageCodeAsString()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("SubmitTime", (Object)this.submitTime()).add("EndTime", (Object)this.endTime()).add("TrainingStartTime", (Object)this.trainingStartTime()).add("TrainingEndTime", (Object)this.trainingEndTime()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ClassifierMetadata", (Object)this.classifierMetadata()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("VolumeKmsKeyId", (Object)this.volumeKmsKeyId()).add("VpcConfig", (Object)this.vpcConfig()).add("Mode", (Object)this.modeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentClassifierArn": {
                return Optional.ofNullable(clazz.cast(this.documentClassifierArn()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "SubmitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "TrainingStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingStartTime()));
            }
            case "TrainingEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingEndTime()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ClassifierMetadata": {
                return Optional.ofNullable(clazz.cast(this.classifierMetadata()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "VolumeKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.volumeKmsKeyId()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassifierProperties, T> g) {
        return obj -> g.apply((DocumentClassifierProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentClassifierArn;
        private String languageCode;
        private String status;
        private String message;
        private Instant submitTime;
        private Instant endTime;
        private Instant trainingStartTime;
        private Instant trainingEndTime;
        private DocumentClassifierInputDataConfig inputDataConfig;
        private DocumentClassifierOutputDataConfig outputDataConfig;
        private ClassifierMetadata classifierMetadata;
        private String dataAccessRoleArn;
        private String volumeKmsKeyId;
        private VpcConfig vpcConfig;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassifierProperties model) {
            this.documentClassifierArn(model.documentClassifierArn);
            this.languageCode(model.languageCode);
            this.status(model.status);
            this.message(model.message);
            this.submitTime(model.submitTime);
            this.endTime(model.endTime);
            this.trainingStartTime(model.trainingStartTime);
            this.trainingEndTime(model.trainingEndTime);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.classifierMetadata(model.classifierMetadata);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.volumeKmsKeyId(model.volumeKmsKeyId);
            this.vpcConfig(model.vpcConfig);
            this.mode(model.mode);
        }

        public final String getDocumentClassifierArn() {
            return this.documentClassifierArn;
        }

        @Override
        public final Builder documentClassifierArn(String documentClassifierArn) {
            this.documentClassifierArn = documentClassifierArn;
            return this;
        }

        public final void setDocumentClassifierArn(String documentClassifierArn) {
            this.documentClassifierArn = documentClassifierArn;
        }

        public final String getLanguageCodeAsString() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getTrainingStartTime() {
            return this.trainingStartTime;
        }

        @Override
        public final Builder trainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
            return this;
        }

        public final void setTrainingStartTime(Instant trainingStartTime) {
            this.trainingStartTime = trainingStartTime;
        }

        public final Instant getTrainingEndTime() {
            return this.trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final DocumentClassifierInputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(DocumentClassifierInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(DocumentClassifierInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final DocumentClassifierOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(DocumentClassifierOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(DocumentClassifierOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ClassifierMetadata.Builder getClassifierMetadata() {
            return this.classifierMetadata != null ? this.classifierMetadata.toBuilder() : null;
        }

        @Override
        public final Builder classifierMetadata(ClassifierMetadata classifierMetadata) {
            this.classifierMetadata = classifierMetadata;
            return this;
        }

        public final void setClassifierMetadata(ClassifierMetadata.BuilderImpl classifierMetadata) {
            this.classifierMetadata = classifierMetadata != null ? classifierMetadata.build() : null;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getModeAsString() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DocumentClassifierMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public DocumentClassifierProperties build() {
            return new DocumentClassifierProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentClassifierProperties> {
        public Builder documentClassifierArn(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder message(String var1);

        public Builder submitTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder trainingStartTime(Instant var1);

        public Builder trainingEndTime(Instant var1);

        public Builder inputDataConfig(DocumentClassifierInputDataConfig var1);

        default public Builder inputDataConfig(Consumer<DocumentClassifierInputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((DocumentClassifierInputDataConfig)((DocumentClassifierInputDataConfig.Builder)DocumentClassifierInputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(DocumentClassifierOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<DocumentClassifierOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((DocumentClassifierOutputDataConfig)((DocumentClassifierOutputDataConfig.Builder)DocumentClassifierOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder classifierMetadata(ClassifierMetadata var1);

        default public Builder classifierMetadata(Consumer<ClassifierMetadata.Builder> classifierMetadata) {
            return this.classifierMetadata((ClassifierMetadata)((ClassifierMetadata.Builder)ClassifierMetadata.builder().applyMutation(classifierMetadata)).build());
        }

        public Builder dataAccessRoleArn(String var1);

        public Builder volumeKmsKeyId(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder mode(String var1);

        public Builder mode(DocumentClassifierMode var1);
    }
}

