/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of calling the operation. The operation returns one object for each document that is successfully
 * processed by the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectSentimentItemResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDetectSentimentItemResult.Builder, BatchDetectSentimentItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchDetectSentimentItemResult::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<String> SENTIMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BatchDetectSentimentItemResult::sentimentAsString)).setter(setter(Builder::sentiment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sentiment").build()).build();

    private static final SdkField<SentimentScore> SENTIMENT_SCORE_FIELD = SdkField
            .<SentimentScore> builder(MarshallingType.SDK_POJO).getter(getter(BatchDetectSentimentItemResult::sentimentScore))
            .setter(setter(Builder::sentimentScore)).constructor(SentimentScore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, SENTIMENT_FIELD,
            SENTIMENT_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer index;

    private final String sentiment;

    private final SentimentScore sentimentScore;

    private BatchDetectSentimentItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    /**
     * <p>
     * The zero-based index of the document in the input list.
     * </p>
     * 
     * @return The zero-based index of the document in the input list.
     */
    public Integer index() {
        return index;
    }

    /**
     * <p>
     * The sentiment detected in the document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link SentimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return The sentiment detected in the document.
     * @see SentimentType
     */
    public SentimentType sentiment() {
        return SentimentType.fromValue(sentiment);
    }

    /**
     * <p>
     * The sentiment detected in the document.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sentiment} will
     * return {@link SentimentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sentimentAsString}.
     * </p>
     * 
     * @return The sentiment detected in the document.
     * @see SentimentType
     */
    public String sentimentAsString() {
        return sentiment;
    }

    /**
     * <p>
     * The level of confidence that Amazon Comprehend has in the accuracy of its sentiment detection.
     * </p>
     * 
     * @return The level of confidence that Amazon Comprehend has in the accuracy of its sentiment detection.
     */
    public SentimentScore sentimentScore() {
        return sentimentScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sentimentScore());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSentimentItemResult)) {
            return false;
        }
        BatchDetectSentimentItemResult other = (BatchDetectSentimentItemResult) obj;
        return Objects.equals(index(), other.index()) && Objects.equals(sentimentAsString(), other.sentimentAsString())
                && Objects.equals(sentimentScore(), other.sentimentScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDetectSentimentItemResult").add("Index", index()).add("Sentiment", sentimentAsString())
                .add("SentimentScore", sentimentScore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "Sentiment":
            return Optional.ofNullable(clazz.cast(sentimentAsString()));
        case "SentimentScore":
            return Optional.ofNullable(clazz.cast(sentimentScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectSentimentItemResult, T> g) {
        return obj -> g.apply((BatchDetectSentimentItemResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDetectSentimentItemResult> {
        /**
         * <p>
         * The zero-based index of the document in the input list.
         * </p>
         * 
         * @param index
         *        The zero-based index of the document in the input list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * <p>
         * The sentiment detected in the document.
         * </p>
         * 
         * @param sentiment
         *        The sentiment detected in the document.
         * @see SentimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentType
         */
        Builder sentiment(String sentiment);

        /**
         * <p>
         * The sentiment detected in the document.
         * </p>
         * 
         * @param sentiment
         *        The sentiment detected in the document.
         * @see SentimentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SentimentType
         */
        Builder sentiment(SentimentType sentiment);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend has in the accuracy of its sentiment detection.
         * </p>
         * 
         * @param sentimentScore
         *        The level of confidence that Amazon Comprehend has in the accuracy of its sentiment detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentScore(SentimentScore sentimentScore);

        /**
         * <p>
         * The level of confidence that Amazon Comprehend has in the accuracy of its sentiment detection.
         * </p>
         * This is a convenience that creates an instance of the {@link SentimentScore.Builder} avoiding the need to
         * create one manually via {@link SentimentScore#builder()}.
         *
         * When the {@link Consumer} completes, {@link SentimentScore.Builder#build()} is called immediately and its
         * result is passed to {@link #sentimentScore(SentimentScore)}.
         * 
         * @param sentimentScore
         *        a consumer that will call methods on {@link SentimentScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentScore(SentimentScore)
         */
        default Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return sentimentScore(SentimentScore.builder().applyMutation(sentimentScore).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer index;

        private String sentiment;

        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSentimentItemResult model) {
            index(model.index);
            sentiment(model.sentiment);
            sentimentScore(model.sentimentScore);
        }

        public final Integer getIndex() {
            return index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final String getSentimentAsString() {
            return sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment == null ? null : sentiment.toString());
            return this;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return sentimentScore != null ? sentimentScore.toBuilder() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        @Override
        public BatchDetectSentimentItemResult build() {
            return new BatchDetectSentimentItemResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
