/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.BatchItemError;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchItemErrorMarshaller {
    private static final MarshallingInfo<Integer> INDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Index").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final BatchItemErrorMarshaller INSTANCE = new BatchItemErrorMarshaller();

    private BatchItemErrorMarshaller() {
    }

    public static BatchItemErrorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchItemError batchItemError, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchItemError, (String)"batchItemError");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchItemError.index(), INDEX_BINDING);
            protocolMarshaller.marshall((Object)batchItemError.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)batchItemError.errorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

