/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDetectSentimentItemResultMarshaller {
    private static final MarshallingInfo<Integer> INDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Index").isBinary(false).build();
    private static final MarshallingInfo<String> SENTIMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sentiment").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SENTIMENTSCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SentimentScore").isBinary(false).build();
    private static final BatchDetectSentimentItemResultMarshaller INSTANCE = new BatchDetectSentimentItemResultMarshaller();

    private BatchDetectSentimentItemResultMarshaller() {
    }

    public static BatchDetectSentimentItemResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchDetectSentimentItemResult batchDetectSentimentItemResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchDetectSentimentItemResult, (String)"batchDetectSentimentItemResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchDetectSentimentItemResult.index(), INDEX_BINDING);
            protocolMarshaller.marshall((Object)batchDetectSentimentItemResult.sentimentString(), SENTIMENT_BINDING);
            protocolMarshaller.marshall((Object)batchDetectSentimentItemResult.sentimentScore(), SENTIMENTSCORE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

