/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobProperties;

@SdkInternalApi
public class TopicsDetectionJobPropertiesMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Instant> SUBMITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTime").build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<StructuredPojo> INPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataConfig").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTDATACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputDataConfig").build();
    private static final MarshallingInfo<Integer> NUMBEROFTOPICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfTopics").build();
    private static final TopicsDetectionJobPropertiesMarshaller INSTANCE = new TopicsDetectionJobPropertiesMarshaller();

    public static TopicsDetectionJobPropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TopicsDetectionJobProperties topicsDetectionJobProperties, ProtocolMarshaller protocolMarshaller) {
        if (topicsDetectionJobProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.jobStatusString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.submitTime(), SUBMITTIME_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.inputDataConfig(), INPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.outputDataConfig(), OUTPUTDATACONFIG_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobProperties.numberOfTopics(), NUMBEROFTOPICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

