/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.SentimentScore;

@SdkInternalApi
public class SentimentScoreMarshaller {
    private static final MarshallingInfo<Float> POSITIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Positive").build();
    private static final MarshallingInfo<Float> NEGATIVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Negative").build();
    private static final MarshallingInfo<Float> NEUTRAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Neutral").build();
    private static final MarshallingInfo<Float> MIXED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mixed").build();
    private static final SentimentScoreMarshaller INSTANCE = new SentimentScoreMarshaller();

    public static SentimentScoreMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SentimentScore sentimentScore, ProtocolMarshaller protocolMarshaller) {
        if (sentimentScore == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sentimentScore.positive(), POSITIVE_BINDING);
            protocolMarshaller.marshall((Object)sentimentScore.negative(), NEGATIVE_BINDING);
            protocolMarshaller.marshall((Object)sentimentScore.neutral(), NEUTRAL_BINDING);
            protocolMarshaller.marshall((Object)sentimentScore.mixed(), MIXED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

