/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.KeyPhrase;

@SdkInternalApi
public class KeyPhraseMarshaller {
    private static final MarshallingInfo<Float> SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Score").build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").build();
    private static final MarshallingInfo<Integer> BEGINOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginOffset").build();
    private static final MarshallingInfo<Integer> ENDOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndOffset").build();
    private static final KeyPhraseMarshaller INSTANCE = new KeyPhraseMarshaller();

    public static KeyPhraseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyPhrase keyPhrase, ProtocolMarshaller protocolMarshaller) {
        if (keyPhrase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keyPhrase.score(), SCORE_BINDING);
            protocolMarshaller.marshall((Object)keyPhrase.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)keyPhrase.beginOffset(), BEGINOFFSET_BINDING);
            protocolMarshaller.marshall((Object)keyPhrase.endOffset(), ENDOFFSET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

