/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PartOfSpeechTagMarshaller {
    private static final MarshallingInfo<String> TAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tag").isBinary(false).build();
    private static final MarshallingInfo<Float> SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Score").isBinary(false).build();
    private static final PartOfSpeechTagMarshaller INSTANCE = new PartOfSpeechTagMarshaller();

    private PartOfSpeechTagMarshaller() {
    }

    public static PartOfSpeechTagMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PartOfSpeechTag partOfSpeechTag, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)partOfSpeechTag, (String)"partOfSpeechTag");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)partOfSpeechTag.tagAsString(), TAG_BINDING);
            protocolMarshaller.marshall((Object)partOfSpeechTag.score(), SCORE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

