/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.KeyPhrase;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeyPhraseMarshaller {
    private static final MarshallingInfo<Float> SCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Score").isBinary(false).build();
    private static final MarshallingInfo<String> TEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Text").isBinary(false).build();
    private static final MarshallingInfo<Integer> BEGINOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BeginOffset").isBinary(false).build();
    private static final MarshallingInfo<Integer> ENDOFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndOffset").isBinary(false).build();
    private static final KeyPhraseMarshaller INSTANCE = new KeyPhraseMarshaller();

    private KeyPhraseMarshaller() {
    }

    public static KeyPhraseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyPhrase keyPhrase, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keyPhrase, (String)"keyPhrase");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keyPhrase.score(), SCORE_BINDING);
            protocolMarshaller.marshall((Object)keyPhrase.text(), TEXT_BINDING);
            protocolMarshaller.marshall((Object)keyPhrase.beginOffset(), BEGINOFFSET_BINDING);
            protocolMarshaller.marshall((Object)keyPhrase.endOffset(), ENDOFFSET_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

