/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.transform.SentimentScoreMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SentimentScore
implements StructuredPojo,
ToCopyableBuilder<Builder, SentimentScore> {
    private final Float positive;
    private final Float negative;
    private final Float neutral;
    private final Float mixed;

    private SentimentScore(BuilderImpl builder) {
        this.positive = builder.positive;
        this.negative = builder.negative;
        this.neutral = builder.neutral;
        this.mixed = builder.mixed;
    }

    public Float positive() {
        return this.positive;
    }

    public Float negative() {
        return this.negative;
    }

    public Float neutral() {
        return this.neutral;
    }

    public Float mixed() {
        return this.mixed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.positive());
        hashCode = 31 * hashCode + Objects.hashCode(this.negative());
        hashCode = 31 * hashCode + Objects.hashCode(this.neutral());
        hashCode = 31 * hashCode + Objects.hashCode(this.mixed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SentimentScore)) {
            return false;
        }
        SentimentScore other = (SentimentScore)obj;
        return Objects.equals(this.positive(), other.positive()) && Objects.equals(this.negative(), other.negative()) && Objects.equals(this.neutral(), other.neutral()) && Objects.equals(this.mixed(), other.mixed());
    }

    public String toString() {
        return ToString.builder((String)"SentimentScore").add("Positive", (Object)this.positive()).add("Negative", (Object)this.negative()).add("Neutral", (Object)this.neutral()).add("Mixed", (Object)this.mixed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Positive": {
                return Optional.ofNullable(clazz.cast(this.positive()));
            }
            case "Negative": {
                return Optional.ofNullable(clazz.cast(this.negative()));
            }
            case "Neutral": {
                return Optional.ofNullable(clazz.cast(this.neutral()));
            }
            case "Mixed": {
                return Optional.ofNullable(clazz.cast(this.mixed()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SentimentScoreMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float positive;
        private Float negative;
        private Float neutral;
        private Float mixed;

        private BuilderImpl() {
        }

        private BuilderImpl(SentimentScore model) {
            this.positive(model.positive);
            this.negative(model.negative);
            this.neutral(model.neutral);
            this.mixed(model.mixed);
        }

        public final Float getPositive() {
            return this.positive;
        }

        @Override
        public final Builder positive(Float positive) {
            this.positive = positive;
            return this;
        }

        public final void setPositive(Float positive) {
            this.positive = positive;
        }

        public final Float getNegative() {
            return this.negative;
        }

        @Override
        public final Builder negative(Float negative) {
            this.negative = negative;
            return this;
        }

        public final void setNegative(Float negative) {
            this.negative = negative;
        }

        public final Float getNeutral() {
            return this.neutral;
        }

        @Override
        public final Builder neutral(Float neutral) {
            this.neutral = neutral;
            return this;
        }

        public final void setNeutral(Float neutral) {
            this.neutral = neutral;
        }

        public final Float getMixed() {
            return this.mixed;
        }

        @Override
        public final Builder mixed(Float mixed) {
            this.mixed = mixed;
            return this;
        }

        public final void setMixed(Float mixed) {
            this.mixed = mixed;
        }

        public SentimentScore build() {
            return new SentimentScore(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SentimentScore> {
        public Builder positive(Float var1);

        public Builder negative(Float var1);

        public Builder neutral(Float var1);

        public Builder mixed(Float var1);
    }
}

