/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.PartOfSpeechTagType;
import software.amazon.awssdk.services.comprehend.transform.PartOfSpeechTagMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PartOfSpeechTag
implements StructuredPojo,
ToCopyableBuilder<Builder, PartOfSpeechTag> {
    private final String tag;
    private final Float score;

    private PartOfSpeechTag(BuilderImpl builder) {
        this.tag = builder.tag;
        this.score = builder.score;
    }

    public PartOfSpeechTagType tag() {
        return PartOfSpeechTagType.fromValue(this.tag);
    }

    public String tagAsString() {
        return this.tag;
    }

    public Float score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartOfSpeechTag)) {
            return false;
        }
        PartOfSpeechTag other = (PartOfSpeechTag)obj;
        return Objects.equals(this.tagAsString(), other.tagAsString()) && Objects.equals(this.score(), other.score());
    }

    public String toString() {
        return ToString.builder((String)"PartOfSpeechTag").add("Tag", (Object)this.tagAsString()).add("Score", (Object)this.score()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tag": {
                return Optional.ofNullable(clazz.cast(this.tagAsString()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartOfSpeechTagMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String tag;
        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(PartOfSpeechTag model) {
            this.tag(model.tag);
            this.score(model.score);
        }

        public final String getTag() {
            return this.tag;
        }

        @Override
        public final Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public final Builder tag(PartOfSpeechTagType tag) {
            this.tag(tag.toString());
            return this;
        }

        public final void setTag(String tag) {
            this.tag = tag;
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public PartOfSpeechTag build() {
            return new PartOfSpeechTag(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PartOfSpeechTag> {
        public Builder tag(String var1);

        public Builder tag(PartOfSpeechTagType var1);

        public Builder score(Float var1);
    }
}

