/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.JobStatus;
import software.amazon.awssdk.services.comprehend.transform.EntitiesDetectionJobFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntitiesDetectionJobFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, EntitiesDetectionJobFilter> {
    private final String jobName;
    private final String jobStatus;
    private final Instant submitTimeBefore;
    private final Instant submitTimeAfter;

    private EntitiesDetectionJobFilter(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.submitTimeAfter = builder.submitTimeAfter;
    }

    public String jobName() {
        return this.jobName;
    }

    public JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public Instant submitTimeBefore() {
        return this.submitTimeBefore;
    }

    public Instant submitTimeAfter() {
        return this.submitTimeAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTimeAfter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitiesDetectionJobFilter)) {
            return false;
        }
        EntitiesDetectionJobFilter other = (EntitiesDetectionJobFilter)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.submitTimeBefore(), other.submitTimeBefore()) && Objects.equals(this.submitTimeAfter(), other.submitTimeAfter());
    }

    public String toString() {
        return ToString.builder((String)"EntitiesDetectionJobFilter").add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("SubmitTimeBefore", (Object)this.submitTimeBefore()).add("SubmitTimeAfter", (Object)this.submitTimeAfter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "SubmitTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.submitTimeBefore()));
            }
            case "SubmitTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.submitTimeAfter()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntitiesDetectionJobFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobStatus;
        private Instant submitTimeBefore;
        private Instant submitTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitiesDetectionJobFilter model) {
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.submitTimeBefore(model.submitTimeBefore);
            this.submitTimeAfter(model.submitTimeAfter);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Instant getSubmitTimeBefore() {
            return this.submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        public final Instant getSubmitTimeAfter() {
            return this.submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        public EntitiesDetectionJobFilter build() {
            return new EntitiesDetectionJobFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EntitiesDetectionJobFilter> {
        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder submitTimeBefore(Instant var1);

        public Builder submitTimeAfter(Instant var1);
    }
}

