/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.KeyPhrase;
import software.amazon.awssdk.services.comprehend.model.ListOfKeyPhrasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectKeyPhrasesResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, DetectKeyPhrasesResponse> {
    private final List<KeyPhrase> keyPhrases;

    private DetectKeyPhrasesResponse(BuilderImpl builder) {
        super(builder);
        this.keyPhrases = builder.keyPhrases;
    }

    public List<KeyPhrase> keyPhrases() {
        return this.keyPhrases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPhrases());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectKeyPhrasesResponse)) {
            return false;
        }
        DetectKeyPhrasesResponse other = (DetectKeyPhrasesResponse)((Object)obj);
        return Objects.equals(this.keyPhrases(), other.keyPhrases());
    }

    public String toString() {
        return ToString.builder((String)"DetectKeyPhrasesResponse").add("KeyPhrases", this.keyPhrases()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPhrases": {
                return Optional.ofNullable(clazz.cast(this.keyPhrases()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<KeyPhrase> keyPhrases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectKeyPhrasesResponse model) {
            super(model);
            this.keyPhrases(model.keyPhrases);
        }

        public final Collection<KeyPhrase.Builder> getKeyPhrases() {
            return this.keyPhrases != null ? (Collection)this.keyPhrases.stream().map(KeyPhrase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPhrases(Collection<KeyPhrase> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copy(keyPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(KeyPhrase ... keyPhrases) {
            this.keyPhrases(Arrays.asList(keyPhrases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(Consumer<KeyPhrase.Builder> ... keyPhrases) {
            this.keyPhrases(Stream.of(keyPhrases).map(c -> (KeyPhrase)((KeyPhrase.Builder)KeyPhrase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPhrases(Collection<KeyPhrase.BuilderImpl> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copyFromBuilder(keyPhrases);
        }

        @Override
        public DetectKeyPhrasesResponse build() {
            return new DetectKeyPhrasesResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, DetectKeyPhrasesResponse> {
        public Builder keyPhrases(Collection<KeyPhrase> var1);

        public Builder keyPhrases(KeyPhrase ... var1);

        public Builder keyPhrases(Consumer<KeyPhrase.Builder> ... var1);
    }
}

