/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.InputFormat;
import software.amazon.awssdk.services.comprehend.transform.InputDataConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDataConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, InputDataConfig> {
    private final String s3Uri;
    private final String inputFormat;

    private InputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.inputFormat = builder.inputFormat;
    }

    public String s3Uri() {
        return this.s3Uri;
    }

    public InputFormat inputFormat() {
        return InputFormat.fromValue(this.inputFormat);
    }

    public String inputFormatAsString() {
        return this.inputFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.inputFormatAsString(), other.inputFormatAsString());
    }

    public String toString() {
        return ToString.builder((String)"InputDataConfig").add("S3Uri", (Object)this.s3Uri()).add("InputFormat", (Object)this.inputFormatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "InputFormat": {
                return Optional.ofNullable(clazz.cast(this.inputFormatAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDataConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String inputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            this.s3Uri(model.s3Uri);
            this.inputFormat(model.inputFormat);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat.toString());
            return this;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        public InputDataConfig build() {
            return new InputDataConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputDataConfig> {
        public Builder s3Uri(String var1);

        public Builder inputFormat(String var1);

        public Builder inputFormat(InputFormat var1);
    }
}

