/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.comprehend.model.KeyPhrase;

public class KeyPhraseUnmarshaller
implements Unmarshaller<KeyPhrase, JsonUnmarshallerContext> {
    private static final KeyPhraseUnmarshaller INSTANCE = new KeyPhraseUnmarshaller();

    public KeyPhrase unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeyPhrase.Builder keyPhraseBuilder = KeyPhrase.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Score", targetDepth)) {
                    context.nextToken();
                    keyPhraseBuilder.score((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Text", targetDepth)) {
                    context.nextToken();
                    keyPhraseBuilder.text((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BeginOffset", targetDepth)) {
                    context.nextToken();
                    keyPhraseBuilder.beginOffset((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndOffset", targetDepth)) {
                    context.nextToken();
                    keyPhraseBuilder.endOffset((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KeyPhrase)keyPhraseBuilder.build();
    }

    public static KeyPhraseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

