/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchDetectSentimentRequestMarshaller
implements Marshaller<Request<BatchDetectSentimentRequest>, BatchDetectSentimentRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("Comprehend_20171127.BatchDetectSentiment").serviceName("Amazon Comprehend").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public BatchDetectSentimentRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<BatchDetectSentimentRequest> marshall(BatchDetectSentimentRequest batchDetectSentimentRequest) {
        Validate.paramNotNull((Object)((Object)batchDetectSentimentRequest), (String)"batchDetectSentimentRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)batchDetectSentimentRequest);
            protocolMarshaller.startMarshalling();
            BatchDetectSentimentRequestModelMarshaller.getInstance().marshall(batchDetectSentimentRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

