/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTopicsDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListTopicsDetectionJobsResponse> {
    private final List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList;
    private final String nextToken;

    private ListTopicsDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.topicsDetectionJobPropertiesList = builder.topicsDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList() {
        return this.topicsDetectionJobPropertiesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicsDetectionJobPropertiesList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsDetectionJobsResponse)) {
            return false;
        }
        ListTopicsDetectionJobsResponse other = (ListTopicsDetectionJobsResponse)((Object)obj);
        return Objects.equals(this.topicsDetectionJobPropertiesList(), other.topicsDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTopicsDetectionJobsResponse").add("TopicsDetectionJobPropertiesList", this.topicsDetectionJobPropertiesList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicsDetectionJobPropertiesList": {
                return Optional.of(clazz.cast(this.topicsDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsDetectionJobsResponse model) {
            super(model);
            this.topicsDetectionJobPropertiesList(model.topicsDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<TopicsDetectionJobProperties.Builder> getTopicsDetectionJobPropertiesList() {
            return this.topicsDetectionJobPropertiesList != null ? (Collection)this.topicsDetectionJobPropertiesList.stream().map(TopicsDetectionJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topicsDetectionJobPropertiesList(Collection<TopicsDetectionJobProperties> topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList = TopicsDetectionJobPropertiesListCopier.copy(topicsDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsDetectionJobPropertiesList(TopicsDetectionJobProperties ... topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList(Arrays.asList(topicsDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicsDetectionJobPropertiesList(Consumer<TopicsDetectionJobProperties.Builder> ... topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList(Stream.of(topicsDetectionJobPropertiesList).map(c -> (TopicsDetectionJobProperties)((TopicsDetectionJobProperties.Builder)TopicsDetectionJobProperties.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopicsDetectionJobPropertiesList(Collection<TopicsDetectionJobProperties.BuilderImpl> topicsDetectionJobPropertiesList) {
            this.topicsDetectionJobPropertiesList = TopicsDetectionJobPropertiesListCopier.copyFromBuilder(topicsDetectionJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTopicsDetectionJobsResponse build() {
            return new ListTopicsDetectionJobsResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, ListTopicsDetectionJobsResponse> {
        public Builder topicsDetectionJobPropertiesList(Collection<TopicsDetectionJobProperties> var1);

        public Builder topicsDetectionJobPropertiesList(TopicsDetectionJobProperties ... var1);

        public Builder topicsDetectionJobPropertiesList(Consumer<TopicsDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

