/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.comprehend.model.ComprehendRequest;
import software.amazon.awssdk.services.comprehend.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDetectDominantLanguageRequest
extends ComprehendRequest
implements ToCopyableBuilder<Builder, BatchDetectDominantLanguageRequest> {
    private final List<String> textList;

    private BatchDetectDominantLanguageRequest(BuilderImpl builder) {
        super(builder);
        this.textList = builder.textList;
    }

    public List<String> textList() {
        return this.textList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectDominantLanguageRequest)) {
            return false;
        }
        BatchDetectDominantLanguageRequest other = (BatchDetectDominantLanguageRequest)((Object)obj);
        return Objects.equals(this.textList(), other.textList());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectDominantLanguageRequest").add("TextList", this.textList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextList": {
                return Optional.of(clazz.cast(this.textList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendRequest.BuilderImpl
    implements Builder {
        private List<String> textList;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectDominantLanguageRequest model) {
            super(model);
            this.textList(model.textList);
        }

        public final Collection<String> getTextList() {
            return this.textList;
        }

        @Override
        public final Builder textList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textList(String ... textList) {
            this.textList(Arrays.asList(textList));
            return this;
        }

        public final void setTextList(Collection<String> textList) {
            this.textList = StringListCopier.copy(textList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchDetectDominantLanguageRequest build() {
            return new BatchDetectDominantLanguageRequest(this);
        }
    }

    public static interface Builder
    extends ComprehendRequest.Builder,
    CopyableBuilder<Builder, BatchDetectDominantLanguageRequest> {
        public Builder textList(Collection<String> var1);

        public Builder textList(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

