/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatasetRequest
extends CognitoSyncRequest
implements ToCopyableBuilder<Builder, DescribeDatasetRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDatasetRequest.getter(DescribeDatasetRequest::identityPoolId)).setter(DescribeDatasetRequest.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDatasetRequest.getter(DescribeDatasetRequest::identityId)).setter(DescribeDatasetRequest.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IdentityId").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDatasetRequest.getter(DescribeDatasetRequest::datasetName)).setter(DescribeDatasetRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DatasetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, IDENTITY_ID_FIELD, DATASET_NAME_FIELD));
    private final String identityPoolId;
    private final String identityId;
    private final String datasetName;

    private DescribeDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.datasetName = builder.datasetName;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public String datasetName() {
        return this.datasetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetRequest)) {
            return false;
        }
        DescribeDatasetRequest other = (DescribeDatasetRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.datasetName(), other.datasetName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDatasetRequest").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityId", (Object)this.identityId()).add("DatasetName", (Object)this.datasetName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetRequest, T> g) {
        return obj -> g.apply((DescribeDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoSyncRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private String datasetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetRequest model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.datasetName(model.datasetName);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDatasetRequest build() {
            return new DescribeDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatasetRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder datasetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

