/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitosync.CognitoSyncAsyncClient;
import software.amazon.awssdk.services.cognitosync.CognitoSyncAsyncClientBuilder;
import software.amazon.awssdk.services.cognitosync.CognitoSyncServiceClientConfiguration;
import software.amazon.awssdk.services.cognitosync.DefaultCognitoSyncAsyncClient;
import software.amazon.awssdk.services.cognitosync.DefaultCognitoSyncBaseClientBuilder;
import software.amazon.awssdk.services.cognitosync.endpoints.CognitoSyncEndpointProvider;

@SdkInternalApi
final class DefaultCognitoSyncAsyncClientBuilder
extends DefaultCognitoSyncBaseClientBuilder<CognitoSyncAsyncClientBuilder, CognitoSyncAsyncClient>
implements CognitoSyncAsyncClientBuilder {
    DefaultCognitoSyncAsyncClientBuilder() {
    }

    @Override
    public DefaultCognitoSyncAsyncClientBuilder endpointProvider(CognitoSyncEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CognitoSyncAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCognitoSyncAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CognitoSyncServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCognitoSyncAsyncClient client = new DefaultCognitoSyncAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CognitoSyncServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CognitoSyncServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

