/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Configuration options for configure Cognito streams.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CognitoStreams implements SdkPojo, Serializable, ToCopyableBuilder<CognitoStreams.Builder, CognitoStreams> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(CognitoStreams::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CognitoStreams::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STREAMING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamingStatus").getter(getter(CognitoStreams::streamingStatusAsString))
            .setter(setter(Builder::streamingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            ROLE_ARN_FIELD, STREAMING_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamName;

    private final String roleArn;

    private final String streamingStatus;

    private CognitoStreams(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.roleArn = builder.roleArn;
        this.streamingStatus = builder.streamingStatus;
    }

    /**
     * The name of the Cognito stream to receive updates. This stream must be in the developers account and in the same
     * region as the identity pool.
     * 
     * @return The name of the Cognito stream to receive updates. This stream must be in the developers account and in
     *         the same region as the identity pool.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * The ARN of the role Amazon Cognito can assume in order to publish to the stream. This role must grant access to
     * Amazon Cognito (cognito-sync) to invoke PutRecord on your Cognito stream.
     * 
     * @return The ARN of the role Amazon Cognito can assume in order to publish to the stream. This role must grant
     *         access to Amazon Cognito (cognito-sync) to invoke PutRecord on your Cognito stream.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Status of the Cognito streams. Valid values are:
     * <p>
     * ENABLED - Streaming of updates to identity pool is enabled.
     * </p>
     * <p>
     * DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if StreamingStatus is
     * DISABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamingStatus}
     * will return {@link StreamingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamingStatusAsString}.
     * </p>
     * 
     * @return Status of the Cognito streams. Valid values are:
     *         <p>
     *         ENABLED - Streaming of updates to identity pool is enabled.
     *         </p>
     *         <p>
     *         DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if
     *         StreamingStatus is DISABLED.
     *         </p>
     * @see StreamingStatus
     */
    public final StreamingStatus streamingStatus() {
        return StreamingStatus.fromValue(streamingStatus);
    }

    /**
     * Status of the Cognito streams. Valid values are:
     * <p>
     * ENABLED - Streaming of updates to identity pool is enabled.
     * </p>
     * <p>
     * DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if StreamingStatus is
     * DISABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamingStatus}
     * will return {@link StreamingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #streamingStatusAsString}.
     * </p>
     * 
     * @return Status of the Cognito streams. Valid values are:
     *         <p>
     *         ENABLED - Streaming of updates to identity pool is enabled.
     *         </p>
     *         <p>
     *         DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if
     *         StreamingStatus is DISABLED.
     *         </p>
     * @see StreamingStatus
     */
    public final String streamingStatusAsString() {
        return streamingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamingStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoStreams)) {
            return false;
        }
        CognitoStreams other = (CognitoStreams) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(streamingStatusAsString(), other.streamingStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CognitoStreams").add("StreamName", streamName()).add("RoleArn", roleArn())
                .add("StreamingStatus", streamingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StreamingStatus":
            return Optional.ofNullable(clazz.cast(streamingStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoStreams, T> g) {
        return obj -> g.apply((CognitoStreams) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CognitoStreams> {
        /**
         * The name of the Cognito stream to receive updates. This stream must be in the developers account and in the
         * same region as the identity pool.
         * 
         * @param streamName
         *        The name of the Cognito stream to receive updates. This stream must be in the developers account and
         *        in the same region as the identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * The ARN of the role Amazon Cognito can assume in order to publish to the stream. This role must grant access
         * to Amazon Cognito (cognito-sync) to invoke PutRecord on your Cognito stream.
         * 
         * @param roleArn
         *        The ARN of the role Amazon Cognito can assume in order to publish to the stream. This role must grant
         *        access to Amazon Cognito (cognito-sync) to invoke PutRecord on your Cognito stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Status of the Cognito streams. Valid values are:
         * <p>
         * ENABLED - Streaming of updates to identity pool is enabled.
         * </p>
         * <p>
         * DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if StreamingStatus
         * is DISABLED.
         * </p>
         * 
         * @param streamingStatus
         *        Status of the Cognito streams. Valid values are:
         *        <p>
         *        ENABLED - Streaming of updates to identity pool is enabled.
         *        </p>
         *        <p>
         *        DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if
         *        StreamingStatus is DISABLED.
         *        </p>
         * @see StreamingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingStatus
         */
        Builder streamingStatus(String streamingStatus);

        /**
         * Status of the Cognito streams. Valid values are:
         * <p>
         * ENABLED - Streaming of updates to identity pool is enabled.
         * </p>
         * <p>
         * DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if StreamingStatus
         * is DISABLED.
         * </p>
         * 
         * @param streamingStatus
         *        Status of the Cognito streams. Valid values are:
         *        <p>
         *        ENABLED - Streaming of updates to identity pool is enabled.
         *        </p>
         *        <p>
         *        DISABLED - Streaming of updates to identity pool is disabled. Bulk publish will also fail if
         *        StreamingStatus is DISABLED.
         *        </p>
         * @see StreamingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamingStatus
         */
        Builder streamingStatus(StreamingStatus streamingStatus);
    }

    static final class BuilderImpl implements Builder {
        private String streamName;

        private String roleArn;

        private String streamingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoStreams model) {
            streamName(model.streamName);
            roleArn(model.roleArn);
            streamingStatus(model.streamingStatus);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamingStatus() {
            return streamingStatus;
        }

        @Override
        public final Builder streamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
            return this;
        }

        @Override
        public final Builder streamingStatus(StreamingStatus streamingStatus) {
            this.streamingStatus(streamingStatus == null ? null : streamingStatus.toString());
            return this;
        }

        public final void setStreamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
        }

        @Override
        public CognitoStreams build() {
            return new CognitoStreams(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
