/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBulkPublishDetailsResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, GetBulkPublishDetailsResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(GetBulkPublishDetailsResponse.getter(GetBulkPublishDetailsResponse::identityPoolId)).setter(GetBulkPublishDetailsResponse.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<Instant> BULK_PUBLISH_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BulkPublishStartTime").getter(GetBulkPublishDetailsResponse.getter(GetBulkPublishDetailsResponse::bulkPublishStartTime)).setter(GetBulkPublishDetailsResponse.setter(Builder::bulkPublishStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkPublishStartTime").build()}).build();
    private static final SdkField<Instant> BULK_PUBLISH_COMPLETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BulkPublishCompleteTime").getter(GetBulkPublishDetailsResponse.getter(GetBulkPublishDetailsResponse::bulkPublishCompleteTime)).setter(GetBulkPublishDetailsResponse.setter(Builder::bulkPublishCompleteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkPublishCompleteTime").build()}).build();
    private static final SdkField<String> BULK_PUBLISH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BulkPublishStatus").getter(GetBulkPublishDetailsResponse.getter(GetBulkPublishDetailsResponse::bulkPublishStatusAsString)).setter(GetBulkPublishDetailsResponse.setter(Builder::bulkPublishStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkPublishStatus").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(GetBulkPublishDetailsResponse.getter(GetBulkPublishDetailsResponse::failureMessage)).setter(GetBulkPublishDetailsResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, BULK_PUBLISH_START_TIME_FIELD, BULK_PUBLISH_COMPLETE_TIME_FIELD, BULK_PUBLISH_STATUS_FIELD, FAILURE_MESSAGE_FIELD));
    private final String identityPoolId;
    private final Instant bulkPublishStartTime;
    private final Instant bulkPublishCompleteTime;
    private final String bulkPublishStatus;
    private final String failureMessage;

    private GetBulkPublishDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.bulkPublishStartTime = builder.bulkPublishStartTime;
        this.bulkPublishCompleteTime = builder.bulkPublishCompleteTime;
        this.bulkPublishStatus = builder.bulkPublishStatus;
        this.failureMessage = builder.failureMessage;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Instant bulkPublishStartTime() {
        return this.bulkPublishStartTime;
    }

    public Instant bulkPublishCompleteTime() {
        return this.bulkPublishCompleteTime;
    }

    public BulkPublishStatus bulkPublishStatus() {
        return BulkPublishStatus.fromValue(this.bulkPublishStatus);
    }

    public String bulkPublishStatusAsString() {
        return this.bulkPublishStatus;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkPublishStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkPublishCompleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkPublishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBulkPublishDetailsResponse)) {
            return false;
        }
        GetBulkPublishDetailsResponse other = (GetBulkPublishDetailsResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.bulkPublishStartTime(), other.bulkPublishStartTime()) && Objects.equals(this.bulkPublishCompleteTime(), other.bulkPublishCompleteTime()) && Objects.equals(this.bulkPublishStatusAsString(), other.bulkPublishStatusAsString()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public String toString() {
        return ToString.builder((String)"GetBulkPublishDetailsResponse").add("IdentityPoolId", (Object)this.identityPoolId()).add("BulkPublishStartTime", (Object)this.bulkPublishStartTime()).add("BulkPublishCompleteTime", (Object)this.bulkPublishCompleteTime()).add("BulkPublishStatus", (Object)this.bulkPublishStatusAsString()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "BulkPublishStartTime": {
                return Optional.ofNullable(clazz.cast(this.bulkPublishStartTime()));
            }
            case "BulkPublishCompleteTime": {
                return Optional.ofNullable(clazz.cast(this.bulkPublishCompleteTime()));
            }
            case "BulkPublishStatus": {
                return Optional.ofNullable(clazz.cast(this.bulkPublishStatusAsString()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBulkPublishDetailsResponse, T> g) {
        return obj -> g.apply((GetBulkPublishDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Instant bulkPublishStartTime;
        private Instant bulkPublishCompleteTime;
        private String bulkPublishStatus;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBulkPublishDetailsResponse model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.bulkPublishStartTime(model.bulkPublishStartTime);
            this.bulkPublishCompleteTime(model.bulkPublishCompleteTime);
            this.bulkPublishStatus(model.bulkPublishStatus);
            this.failureMessage(model.failureMessage);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Instant getBulkPublishStartTime() {
            return this.bulkPublishStartTime;
        }

        @Override
        public final Builder bulkPublishStartTime(Instant bulkPublishStartTime) {
            this.bulkPublishStartTime = bulkPublishStartTime;
            return this;
        }

        public final void setBulkPublishStartTime(Instant bulkPublishStartTime) {
            this.bulkPublishStartTime = bulkPublishStartTime;
        }

        public final Instant getBulkPublishCompleteTime() {
            return this.bulkPublishCompleteTime;
        }

        @Override
        public final Builder bulkPublishCompleteTime(Instant bulkPublishCompleteTime) {
            this.bulkPublishCompleteTime = bulkPublishCompleteTime;
            return this;
        }

        public final void setBulkPublishCompleteTime(Instant bulkPublishCompleteTime) {
            this.bulkPublishCompleteTime = bulkPublishCompleteTime;
        }

        public final String getBulkPublishStatus() {
            return this.bulkPublishStatus;
        }

        @Override
        public final Builder bulkPublishStatus(String bulkPublishStatus) {
            this.bulkPublishStatus = bulkPublishStatus;
            return this;
        }

        @Override
        public final Builder bulkPublishStatus(BulkPublishStatus bulkPublishStatus) {
            this.bulkPublishStatus(bulkPublishStatus == null ? null : bulkPublishStatus.toString());
            return this;
        }

        public final void setBulkPublishStatus(String bulkPublishStatus) {
            this.bulkPublishStatus = bulkPublishStatus;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public GetBulkPublishDetailsResponse build() {
            return new GetBulkPublishDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBulkPublishDetailsResponse> {
        public Builder identityPoolId(String var1);

        public Builder bulkPublishStartTime(Instant var1);

        public Builder bulkPublishCompleteTime(Instant var1);

        public Builder bulkPublishStatus(String var1);

        public Builder bulkPublishStatus(BulkPublishStatus var1);

        public Builder failureMessage(String var1);
    }
}

