/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest;
import software.amazon.awssdk.services.cognitosync.transform.ListRecordsRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListRecordsRequestMarshaller
implements Marshaller<Request<ListRecordsRequest>, ListRecordsRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.REST_JSON).requestUri("/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records").httpMethodName(HttpMethodName.GET).hasExplicitPayloadMember(false).hasPayloadMembers(false).build();
    private final SdkJsonProtocolFactory protocolFactory;

    public ListRecordsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListRecordsRequest> marshall(ListRecordsRequest listRecordsRequest) {
        Validate.paramNotNull((Object)((Object)listRecordsRequest), (String)"listRecordsRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)listRecordsRequest);
            protocolMarshaller.startMarshalling();
            ListRecordsRequestModelMarshaller.getInstance().marshall(listRecordsRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

