/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncRequest;
import software.amazon.awssdk.services.cognitosync.model.RecordPatch;
import software.amazon.awssdk.services.cognitosync.model.RecordPatchListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateRecordsRequest
extends CognitoSyncRequest
implements ToCopyableBuilder<Builder, UpdateRecordsRequest> {
    private final String identityPoolId;
    private final String identityId;
    private final String datasetName;
    private final String deviceId;
    private final List<RecordPatch> recordPatches;
    private final String syncSessionToken;
    private final String clientContext;

    private UpdateRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.datasetName = builder.datasetName;
        this.deviceId = builder.deviceId;
        this.recordPatches = builder.recordPatches;
        this.syncSessionToken = builder.syncSessionToken;
        this.clientContext = builder.clientContext;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public String datasetName() {
        return this.datasetName;
    }

    public String deviceId() {
        return this.deviceId;
    }

    public List<RecordPatch> recordPatches() {
        return this.recordPatches;
    }

    public String syncSessionToken() {
        return this.syncSessionToken;
    }

    public String clientContext() {
        return this.clientContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordPatches());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientContext());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecordsRequest)) {
            return false;
        }
        UpdateRecordsRequest other = (UpdateRecordsRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.recordPatches(), other.recordPatches()) && Objects.equals(this.syncSessionToken(), other.syncSessionToken()) && Objects.equals(this.clientContext(), other.clientContext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.datasetName() != null) {
            sb.append("DatasetName: ").append(this.datasetName()).append(",");
        }
        if (this.deviceId() != null) {
            sb.append("DeviceId: ").append(this.deviceId()).append(",");
        }
        if (this.recordPatches() != null) {
            sb.append("RecordPatches: ").append(this.recordPatches()).append(",");
        }
        if (this.syncSessionToken() != null) {
            sb.append("SyncSessionToken: ").append(this.syncSessionToken()).append(",");
        }
        if (this.clientContext() != null) {
            sb.append("ClientContext: ").append(this.clientContext()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "DatasetName": {
                return Optional.of(clazz.cast(this.datasetName()));
            }
            case "DeviceId": {
                return Optional.of(clazz.cast(this.deviceId()));
            }
            case "RecordPatches": {
                return Optional.of(clazz.cast(this.recordPatches()));
            }
            case "SyncSessionToken": {
                return Optional.of(clazz.cast(this.syncSessionToken()));
            }
            case "ClientContext": {
                return Optional.of(clazz.cast(this.clientContext()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private String datasetName;
        private String deviceId;
        private List<RecordPatch> recordPatches;
        private String syncSessionToken;
        private String clientContext;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecordsRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.datasetName(model.datasetName);
            this.deviceId(model.deviceId);
            this.recordPatches(model.recordPatches);
            this.syncSessionToken(model.syncSessionToken);
            this.clientContext(model.clientContext);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final Collection<RecordPatch.Builder> getRecordPatches() {
            return this.recordPatches != null ? (Collection)this.recordPatches.stream().map(RecordPatch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordPatches(Collection<RecordPatch> recordPatches) {
            this.recordPatches = RecordPatchListCopier.copy(recordPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordPatches(RecordPatch ... recordPatches) {
            this.recordPatches(Arrays.asList(recordPatches));
            return this;
        }

        public final void setRecordPatches(Collection<RecordPatch.BuilderImpl> recordPatches) {
            this.recordPatches = RecordPatchListCopier.copyFromBuilder(recordPatches);
        }

        public final String getSyncSessionToken() {
            return this.syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        public final String getClientContext() {
            return this.clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecordsRequest build() {
            return new UpdateRecordsRequest(this);
        }
    }

    public static interface Builder
    extends CognitoSyncRequest.Builder,
    CopyableBuilder<Builder, UpdateRecordsRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder datasetName(String var1);

        public Builder deviceId(String var1);

        public Builder recordPatches(Collection<RecordPatch> var1);

        public Builder recordPatches(RecordPatch ... var1);

        public Builder syncSessionToken(String var1);

        public Builder clientContext(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

