/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cognitosync.model.EventsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCognitoEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetCognitoEventsResponse> {
    private final Map<String, String> events;

    private GetCognitoEventsResponse(BuilderImpl builder) {
        this.events = builder.events;
    }

    public Map<String, String> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCognitoEventsResponse)) {
            return false;
        }
        GetCognitoEventsResponse other = (GetCognitoEventsResponse)((Object)obj);
        return Objects.equals(this.events(), other.events());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Events": {
                return Optional.of(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> events;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCognitoEventsResponse model) {
            this.events(model.events);
        }

        public final Map<String, String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
            return this;
        }

        public final void setEvents(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
        }

        public GetCognitoEventsResponse build() {
            return new GetCognitoEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetCognitoEventsResponse> {
        public Builder events(Map<String, String> var1);
    }
}

