/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRecordsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListRecordsRequest> {
    private final String identityPoolId;
    private final String identityId;
    private final String datasetName;
    private final Long lastSyncCount;
    private final String nextToken;
    private final Integer maxResults;
    private final String syncSessionToken;

    private ListRecordsRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.datasetName = builder.datasetName;
        this.lastSyncCount = builder.lastSyncCount;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.syncSessionToken = builder.syncSessionToken;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public String datasetName() {
        return this.datasetName;
    }

    public Long lastSyncCount() {
        return this.lastSyncCount;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String syncSessionToken() {
        return this.syncSessionToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.datasetName() == null ? 0 : this.datasetName().hashCode());
        hashCode = 31 * hashCode + (this.lastSyncCount() == null ? 0 : this.lastSyncCount().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.syncSessionToken() == null ? 0 : this.syncSessionToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordsRequest)) {
            return false;
        }
        ListRecordsRequest other = (ListRecordsRequest)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.datasetName() == null ^ this.datasetName() == null) {
            return false;
        }
        if (other.datasetName() != null && !other.datasetName().equals(this.datasetName())) {
            return false;
        }
        if (other.lastSyncCount() == null ^ this.lastSyncCount() == null) {
            return false;
        }
        if (other.lastSyncCount() != null && !other.lastSyncCount().equals(this.lastSyncCount())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.syncSessionToken() == null ^ this.syncSessionToken() == null) {
            return false;
        }
        return other.syncSessionToken() == null || other.syncSessionToken().equals(this.syncSessionToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.datasetName() != null) {
            sb.append("DatasetName: ").append(this.datasetName()).append(",");
        }
        if (this.lastSyncCount() != null) {
            sb.append("LastSyncCount: ").append(this.lastSyncCount()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.syncSessionToken() != null) {
            sb.append("SyncSessionToken: ").append(this.syncSessionToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "DatasetName": {
                return Optional.of(clazz.cast(this.datasetName()));
            }
            case "LastSyncCount": {
                return Optional.of(clazz.cast(this.lastSyncCount()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "SyncSessionToken": {
                return Optional.of(clazz.cast(this.syncSessionToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private String datasetName;
        private Long lastSyncCount;
        private String nextToken;
        private Integer maxResults;
        private String syncSessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordsRequest model) {
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.datasetName(model.datasetName);
            this.lastSyncCount(model.lastSyncCount);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.syncSessionToken(model.syncSessionToken);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final Long getLastSyncCount() {
            return this.lastSyncCount;
        }

        @Override
        public final Builder lastSyncCount(Long lastSyncCount) {
            this.lastSyncCount = lastSyncCount;
            return this;
        }

        public final void setLastSyncCount(Long lastSyncCount) {
            this.lastSyncCount = lastSyncCount;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getSyncSessionToken() {
            return this.syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        public ListRecordsRequest build() {
            return new ListRecordsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRecordsRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder datasetName(String var1);

        public Builder lastSyncCount(Long var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder syncSessionToken(String var1);
    }
}

