/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.model.ApplicationArnListCopier;
import software.amazon.awssdk.services.cognitosync.transform.PushSyncMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PushSync
implements StructuredPojo,
ToCopyableBuilder<Builder, PushSync> {
    private final List<String> applicationArns;
    private final String roleArn;

    private PushSync(BuilderImpl builder) {
        this.applicationArns = builder.applicationArns;
        this.roleArn = builder.roleArn;
    }

    public List<String> applicationArns() {
        return this.applicationArns;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationArns() == null ? 0 : this.applicationArns().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushSync)) {
            return false;
        }
        PushSync other = (PushSync)obj;
        if (other.applicationArns() == null ^ this.applicationArns() == null) {
            return false;
        }
        if (other.applicationArns() != null && !other.applicationArns().equals(this.applicationArns())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        return other.roleArn() == null || other.roleArn().equals(this.roleArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationArns() != null) {
            sb.append("ApplicationArns: ").append(this.applicationArns()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PushSyncMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> applicationArns;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PushSync model) {
            this.setApplicationArns(model.applicationArns);
            this.setRoleArn(model.roleArn);
        }

        public final Collection<String> getApplicationArns() {
            return this.applicationArns;
        }

        @Override
        public final Builder applicationArns(Collection<String> applicationArns) {
            this.applicationArns = ApplicationArnListCopier.copy(applicationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationArns(String ... applicationArns) {
            this.applicationArns(Arrays.asList(applicationArns));
            return this;
        }

        public final void setApplicationArns(Collection<String> applicationArns) {
            this.applicationArns = ApplicationArnListCopier.copy(applicationArns);
        }

        @SafeVarargs
        public final void setApplicationArns(String ... applicationArns) {
            this.applicationArns(Arrays.asList(applicationArns));
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public PushSync build() {
            return new PushSync(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PushSync> {
        public Builder applicationArns(Collection<String> var1);

        public Builder applicationArns(String ... var1);

        public Builder roleArn(String var1);
    }
}

