/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.services.cognitosync.model.EventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCognitoEventsResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, GetCognitoEventsResponse> {
    private final Map<String, String> events;

    private GetCognitoEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
    }

    public Map<String, String> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCognitoEventsResponse)) {
            return false;
        }
        GetCognitoEventsResponse other = (GetCognitoEventsResponse)((Object)obj);
        return Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"GetCognitoEventsResponse").add("Events", this.events()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private Map<String, String> events = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCognitoEventsResponse model) {
            super(model);
            this.events(model.events);
        }

        public final Map<String, String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
            return this;
        }

        public final void setEvents(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
        }

        @Override
        public GetCognitoEventsResponse build() {
            return new GetCognitoEventsResponse(this);
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    CopyableBuilder<Builder, GetCognitoEventsResponse> {
        public Builder events(Map<String, String> var1);
    }
}

