/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishStatus;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBulkPublishDetailsResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, GetBulkPublishDetailsResponse> {
    private final String identityPoolId;
    private final Instant bulkPublishStartTime;
    private final Instant bulkPublishCompleteTime;
    private final String bulkPublishStatus;
    private final String failureMessage;

    private GetBulkPublishDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.bulkPublishStartTime = builder.bulkPublishStartTime;
        this.bulkPublishCompleteTime = builder.bulkPublishCompleteTime;
        this.bulkPublishStatus = builder.bulkPublishStatus;
        this.failureMessage = builder.failureMessage;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Instant bulkPublishStartTime() {
        return this.bulkPublishStartTime;
    }

    public Instant bulkPublishCompleteTime() {
        return this.bulkPublishCompleteTime;
    }

    public BulkPublishStatus bulkPublishStatus() {
        return BulkPublishStatus.fromValue(this.bulkPublishStatus);
    }

    public String bulkPublishStatusAsString() {
        return this.bulkPublishStatus;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkPublishStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkPublishCompleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkPublishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBulkPublishDetailsResponse)) {
            return false;
        }
        GetBulkPublishDetailsResponse other = (GetBulkPublishDetailsResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.bulkPublishStartTime(), other.bulkPublishStartTime()) && Objects.equals(this.bulkPublishCompleteTime(), other.bulkPublishCompleteTime()) && Objects.equals(this.bulkPublishStatusAsString(), other.bulkPublishStatusAsString()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public String toString() {
        return ToString.builder((String)"GetBulkPublishDetailsResponse").add("IdentityPoolId", (Object)this.identityPoolId()).add("BulkPublishStartTime", (Object)this.bulkPublishStartTime()).add("BulkPublishCompleteTime", (Object)this.bulkPublishCompleteTime()).add("BulkPublishStatus", (Object)this.bulkPublishStatusAsString()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "BulkPublishStartTime": {
                return Optional.ofNullable(clazz.cast(this.bulkPublishStartTime()));
            }
            case "BulkPublishCompleteTime": {
                return Optional.ofNullable(clazz.cast(this.bulkPublishCompleteTime()));
            }
            case "BulkPublishStatus": {
                return Optional.ofNullable(clazz.cast(this.bulkPublishStatusAsString()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Instant bulkPublishStartTime;
        private Instant bulkPublishCompleteTime;
        private String bulkPublishStatus;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBulkPublishDetailsResponse model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.bulkPublishStartTime(model.bulkPublishStartTime);
            this.bulkPublishCompleteTime(model.bulkPublishCompleteTime);
            this.bulkPublishStatus(model.bulkPublishStatus);
            this.failureMessage(model.failureMessage);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Instant getBulkPublishStartTime() {
            return this.bulkPublishStartTime;
        }

        @Override
        public final Builder bulkPublishStartTime(Instant bulkPublishStartTime) {
            this.bulkPublishStartTime = bulkPublishStartTime;
            return this;
        }

        public final void setBulkPublishStartTime(Instant bulkPublishStartTime) {
            this.bulkPublishStartTime = bulkPublishStartTime;
        }

        public final Instant getBulkPublishCompleteTime() {
            return this.bulkPublishCompleteTime;
        }

        @Override
        public final Builder bulkPublishCompleteTime(Instant bulkPublishCompleteTime) {
            this.bulkPublishCompleteTime = bulkPublishCompleteTime;
            return this;
        }

        public final void setBulkPublishCompleteTime(Instant bulkPublishCompleteTime) {
            this.bulkPublishCompleteTime = bulkPublishCompleteTime;
        }

        public final String getBulkPublishStatus() {
            return this.bulkPublishStatus;
        }

        @Override
        public final Builder bulkPublishStatus(String bulkPublishStatus) {
            this.bulkPublishStatus = bulkPublishStatus;
            return this;
        }

        @Override
        public final Builder bulkPublishStatus(BulkPublishStatus bulkPublishStatus) {
            this.bulkPublishStatus(bulkPublishStatus.toString());
            return this;
        }

        public final void setBulkPublishStatus(String bulkPublishStatus) {
            this.bulkPublishStatus = bulkPublishStatus;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public GetBulkPublishDetailsResponse build() {
            return new GetBulkPublishDetailsResponse(this);
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    CopyableBuilder<Builder, GetBulkPublishDetailsResponse> {
        public Builder identityPoolId(String var1);

        public Builder bulkPublishStartTime(Instant var1);

        public Builder bulkPublishCompleteTime(Instant var1);

        public Builder bulkPublishStatus(String var1);

        public Builder bulkPublishStatus(BulkPublishStatus var1);

        public Builder failureMessage(String var1);
    }
}

