/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitosync.model.Record;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecordMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<Long> SYNCCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncCount").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<String> LASTMODIFIEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedBy").isBinary(false).build();
    private static final MarshallingInfo<Instant> DEVICELASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceLastModifiedDate").isBinary(false).build();
    private static final RecordMarshaller INSTANCE = new RecordMarshaller();

    private RecordMarshaller() {
    }

    public static RecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Record record, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)record, (String)"record");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)record.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)record.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)record.syncCount(), SYNCCOUNT_BINDING);
            protocolMarshaller.marshall((Object)record.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)record.lastModifiedBy(), LASTMODIFIEDBY_BINDING);
            protocolMarshaller.marshall((Object)record.deviceLastModifiedDate(), DEVICELASTMODIFIEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

