/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitosync.model.CognitoStreams;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CognitoStreamsMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> STREAMINGSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamingStatus").isBinary(false).build();
    private static final CognitoStreamsMarshaller INSTANCE = new CognitoStreamsMarshaller();

    private CognitoStreamsMarshaller() {
    }

    public static CognitoStreamsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CognitoStreams cognitoStreams, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cognitoStreams, (String)"cognitoStreams");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cognitoStreams.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)cognitoStreams.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)cognitoStreams.streamingStatusAsString(), STREAMINGSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

