/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnsubscribeFromDatasetRequest
extends CognitoSyncRequest
implements ToCopyableBuilder<Builder, UnsubscribeFromDatasetRequest> {
    private final String identityPoolId;
    private final String identityId;
    private final String datasetName;
    private final String deviceId;

    private UnsubscribeFromDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.datasetName = builder.datasetName;
        this.deviceId = builder.deviceId;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityId() {
        return this.identityId;
    }

    public String datasetName() {
        return this.datasetName;
    }

    public String deviceId() {
        return this.deviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsubscribeFromDatasetRequest)) {
            return false;
        }
        UnsubscribeFromDatasetRequest other = (UnsubscribeFromDatasetRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.deviceId(), other.deviceId());
    }

    public String toString() {
        return ToString.builder((String)"UnsubscribeFromDatasetRequest").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityId", (Object)this.identityId()).add("DatasetName", (Object)this.datasetName()).add("DeviceId", (Object)this.deviceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "DatasetName": {
                return Optional.of(clazz.cast(this.datasetName()));
            }
            case "DeviceId": {
                return Optional.of(clazz.cast(this.deviceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityId;
        private String datasetName;
        private String deviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsubscribeFromDatasetRequest model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identityId(model.identityId);
            this.datasetName(model.datasetName);
            this.deviceId(model.deviceId);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UnsubscribeFromDatasetRequest build() {
            return new UnsubscribeFromDatasetRequest(this);
        }
    }

    public static interface Builder
    extends CognitoSyncRequest.Builder,
    CopyableBuilder<Builder, UnsubscribeFromDatasetRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityId(String var1);

        public Builder datasetName(String var1);

        public Builder deviceId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

