/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.cognitosync.model.EventsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetCognitoEventsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetCognitoEventsRequest> {
    private final String identityPoolId;
    private final Map<String, String> events;

    private SetCognitoEventsRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.events = builder.events;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Map<String, String> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetCognitoEventsRequest)) {
            return false;
        }
        SetCognitoEventsRequest other = (SetCognitoEventsRequest)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        return other.events() == null || other.events().equals(this.events());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Map<String, String> events = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(SetCognitoEventsRequest model) {
            this.setIdentityPoolId(model.identityPoolId);
            this.setEvents(model.events);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
            return this;
        }

        public final void setEvents(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
        }

        public SetCognitoEventsRequest build() {
            return new SetCognitoEventsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetCognitoEventsRequest> {
        public Builder identityPoolId(String var1);

        public Builder events(Map<String, String> var1);
    }
}

