/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cognitosync.model.MergedDatasetNameListCopier;
import software.amazon.awssdk.services.cognitosync.model.Record;
import software.amazon.awssdk.services.cognitosync.model.RecordListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRecordsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListRecordsResponse> {
    private final List<Record> records;
    private final String nextToken;
    private final Integer count;
    private final Long datasetSyncCount;
    private final String lastModifiedBy;
    private final List<String> mergedDatasetNames;
    private final Boolean datasetExists;
    private final Boolean datasetDeletedAfterRequestedSyncCount;
    private final String syncSessionToken;

    private ListRecordsResponse(BuilderImpl builder) {
        this.records = builder.records;
        this.nextToken = builder.nextToken;
        this.count = builder.count;
        this.datasetSyncCount = builder.datasetSyncCount;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.mergedDatasetNames = builder.mergedDatasetNames;
        this.datasetExists = builder.datasetExists;
        this.datasetDeletedAfterRequestedSyncCount = builder.datasetDeletedAfterRequestedSyncCount;
        this.syncSessionToken = builder.syncSessionToken;
    }

    public List<Record> records() {
        return this.records;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer count() {
        return this.count;
    }

    public Long datasetSyncCount() {
        return this.datasetSyncCount;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public List<String> mergedDatasetNames() {
        return this.mergedDatasetNames;
    }

    public Boolean datasetExists() {
        return this.datasetExists;
    }

    public Boolean datasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public String syncSessionToken() {
        return this.syncSessionToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.records() == null ? 0 : this.records().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.count() == null ? 0 : this.count().hashCode());
        hashCode = 31 * hashCode + (this.datasetSyncCount() == null ? 0 : this.datasetSyncCount().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedBy() == null ? 0 : this.lastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.mergedDatasetNames() == null ? 0 : this.mergedDatasetNames().hashCode());
        hashCode = 31 * hashCode + (this.datasetExists() == null ? 0 : this.datasetExists().hashCode());
        hashCode = 31 * hashCode + (this.datasetDeletedAfterRequestedSyncCount() == null ? 0 : this.datasetDeletedAfterRequestedSyncCount().hashCode());
        hashCode = 31 * hashCode + (this.syncSessionToken() == null ? 0 : this.syncSessionToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordsResponse)) {
            return false;
        }
        ListRecordsResponse other = (ListRecordsResponse)((Object)obj);
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        if (other.records() != null && !other.records().equals(this.records())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.count() == null ^ this.count() == null) {
            return false;
        }
        if (other.count() != null && !other.count().equals(this.count())) {
            return false;
        }
        if (other.datasetSyncCount() == null ^ this.datasetSyncCount() == null) {
            return false;
        }
        if (other.datasetSyncCount() != null && !other.datasetSyncCount().equals(this.datasetSyncCount())) {
            return false;
        }
        if (other.lastModifiedBy() == null ^ this.lastModifiedBy() == null) {
            return false;
        }
        if (other.lastModifiedBy() != null && !other.lastModifiedBy().equals(this.lastModifiedBy())) {
            return false;
        }
        if (other.mergedDatasetNames() == null ^ this.mergedDatasetNames() == null) {
            return false;
        }
        if (other.mergedDatasetNames() != null && !other.mergedDatasetNames().equals(this.mergedDatasetNames())) {
            return false;
        }
        if (other.datasetExists() == null ^ this.datasetExists() == null) {
            return false;
        }
        if (other.datasetExists() != null && !other.datasetExists().equals(this.datasetExists())) {
            return false;
        }
        if (other.datasetDeletedAfterRequestedSyncCount() == null ^ this.datasetDeletedAfterRequestedSyncCount() == null) {
            return false;
        }
        if (other.datasetDeletedAfterRequestedSyncCount() != null && !other.datasetDeletedAfterRequestedSyncCount().equals(this.datasetDeletedAfterRequestedSyncCount())) {
            return false;
        }
        if (other.syncSessionToken() == null ^ this.syncSessionToken() == null) {
            return false;
        }
        return other.syncSessionToken() == null || other.syncSessionToken().equals(this.syncSessionToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.count() != null) {
            sb.append("Count: ").append(this.count()).append(",");
        }
        if (this.datasetSyncCount() != null) {
            sb.append("DatasetSyncCount: ").append(this.datasetSyncCount()).append(",");
        }
        if (this.lastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.lastModifiedBy()).append(",");
        }
        if (this.mergedDatasetNames() != null) {
            sb.append("MergedDatasetNames: ").append(this.mergedDatasetNames()).append(",");
        }
        if (this.datasetExists() != null) {
            sb.append("DatasetExists: ").append(this.datasetExists()).append(",");
        }
        if (this.datasetDeletedAfterRequestedSyncCount() != null) {
            sb.append("DatasetDeletedAfterRequestedSyncCount: ").append(this.datasetDeletedAfterRequestedSyncCount()).append(",");
        }
        if (this.syncSessionToken() != null) {
            sb.append("SyncSessionToken: ").append(this.syncSessionToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Record> records = new SdkInternalList();
        private String nextToken;
        private Integer count;
        private Long datasetSyncCount;
        private String lastModifiedBy;
        private List<String> mergedDatasetNames = new SdkInternalList();
        private Boolean datasetExists;
        private Boolean datasetDeletedAfterRequestedSyncCount;
        private String syncSessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordsResponse model) {
            this.setRecords(model.records);
            this.setNextToken(model.nextToken);
            this.setCount(model.count);
            this.setDatasetSyncCount(model.datasetSyncCount);
            this.setLastModifiedBy(model.lastModifiedBy);
            this.setMergedDatasetNames(model.mergedDatasetNames);
            this.setDatasetExists(model.datasetExists);
            this.setDatasetDeletedAfterRequestedSyncCount(model.datasetDeletedAfterRequestedSyncCount);
            this.setSyncSessionToken(model.syncSessionToken);
        }

        public final Collection<Record> getRecords() {
            return this.records;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            if (this.records == null) {
                this.records = new SdkInternalList(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
            return this;
        }

        public final void setRecords(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
        }

        @SafeVarargs
        public final void setRecords(Record ... records) {
            if (this.records == null) {
                this.records = new SdkInternalList(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Long getDatasetSyncCount() {
            return this.datasetSyncCount;
        }

        @Override
        public final Builder datasetSyncCount(Long datasetSyncCount) {
            this.datasetSyncCount = datasetSyncCount;
            return this;
        }

        public final void setDatasetSyncCount(Long datasetSyncCount) {
            this.datasetSyncCount = datasetSyncCount;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Collection<String> getMergedDatasetNames() {
            return this.mergedDatasetNames;
        }

        @Override
        public final Builder mergedDatasetNames(Collection<String> mergedDatasetNames) {
            this.mergedDatasetNames = MergedDatasetNameListCopier.copy(mergedDatasetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergedDatasetNames(String ... mergedDatasetNames) {
            if (this.mergedDatasetNames == null) {
                this.mergedDatasetNames = new SdkInternalList(mergedDatasetNames.length);
            }
            for (String e : mergedDatasetNames) {
                this.mergedDatasetNames.add(e);
            }
            return this;
        }

        public final void setMergedDatasetNames(Collection<String> mergedDatasetNames) {
            this.mergedDatasetNames = MergedDatasetNameListCopier.copy(mergedDatasetNames);
        }

        @SafeVarargs
        public final void setMergedDatasetNames(String ... mergedDatasetNames) {
            if (this.mergedDatasetNames == null) {
                this.mergedDatasetNames = new SdkInternalList(mergedDatasetNames.length);
            }
            for (String e : mergedDatasetNames) {
                this.mergedDatasetNames.add(e);
            }
        }

        public final Boolean getDatasetExists() {
            return this.datasetExists;
        }

        @Override
        public final Builder datasetExists(Boolean datasetExists) {
            this.datasetExists = datasetExists;
            return this;
        }

        public final void setDatasetExists(Boolean datasetExists) {
            this.datasetExists = datasetExists;
        }

        public final Boolean getDatasetDeletedAfterRequestedSyncCount() {
            return this.datasetDeletedAfterRequestedSyncCount;
        }

        @Override
        public final Builder datasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
            this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
            return this;
        }

        public final void setDatasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
            this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
        }

        public final String getSyncSessionToken() {
            return this.syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        public ListRecordsResponse build() {
            return new ListRecordsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder nextToken(String var1);

        public Builder count(Integer var1);

        public Builder datasetSyncCount(Long var1);

        public Builder lastModifiedBy(String var1);

        public Builder mergedDatasetNames(Collection<String> var1);

        public Builder mergedDatasetNames(String ... var1);

        public Builder datasetExists(Boolean var1);

        public Builder datasetDeletedAfterRequestedSyncCount(Boolean var1);

        public Builder syncSessionToken(String var1);
    }
}

