/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cognitosync.transform.IdentityPoolUsageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IdentityPoolUsage
implements StructuredPojo,
ToCopyableBuilder<Builder, IdentityPoolUsage> {
    private final String identityPoolId;
    private final Long syncSessionsCount;
    private final Long dataStorage;
    private final Date lastModifiedDate;

    private IdentityPoolUsage(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.syncSessionsCount = builder.syncSessionsCount;
        this.dataStorage = builder.dataStorage;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Long syncSessionsCount() {
        return this.syncSessionsCount;
    }

    public Long dataStorage() {
        return this.dataStorage;
    }

    public Date lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.syncSessionsCount() == null ? 0 : this.syncSessionsCount().hashCode());
        hashCode = 31 * hashCode + (this.dataStorage() == null ? 0 : this.dataStorage().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityPoolUsage)) {
            return false;
        }
        IdentityPoolUsage other = (IdentityPoolUsage)obj;
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.syncSessionsCount() == null ^ this.syncSessionsCount() == null) {
            return false;
        }
        if (other.syncSessionsCount() != null && !other.syncSessionsCount().equals(this.syncSessionsCount())) {
            return false;
        }
        if (other.dataStorage() == null ^ this.dataStorage() == null) {
            return false;
        }
        if (other.dataStorage() != null && !other.dataStorage().equals(this.dataStorage())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        return other.lastModifiedDate() == null || other.lastModifiedDate().equals(this.lastModifiedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.syncSessionsCount() != null) {
            sb.append("SyncSessionsCount: ").append(this.syncSessionsCount()).append(",");
        }
        if (this.dataStorage() != null) {
            sb.append("DataStorage: ").append(this.dataStorage()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IdentityPoolUsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Long syncSessionsCount;
        private Long dataStorage;
        private Date lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityPoolUsage model) {
            this.setIdentityPoolId(model.identityPoolId);
            this.setSyncSessionsCount(model.syncSessionsCount);
            this.setDataStorage(model.dataStorage);
            this.setLastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Long getSyncSessionsCount() {
            return this.syncSessionsCount;
        }

        @Override
        public final Builder syncSessionsCount(Long syncSessionsCount) {
            this.syncSessionsCount = syncSessionsCount;
            return this;
        }

        public final void setSyncSessionsCount(Long syncSessionsCount) {
            this.syncSessionsCount = syncSessionsCount;
        }

        public final Long getDataStorage() {
            return this.dataStorage;
        }

        @Override
        public final Builder dataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
            return this;
        }

        public final void setDataStorage(Long dataStorage) {
            this.dataStorage = dataStorage;
        }

        public final Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy((Date)lastModifiedDate);
            return this;
        }

        public final void setLastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = StandardMemberCopier.copy((Date)lastModifiedDate);
        }

        public IdentityPoolUsage build() {
            return new IdentityPoolUsage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IdentityPoolUsage> {
        public Builder identityPoolId(String var1);

        public Builder syncSessionsCount(Long var1);

        public Builder dataStorage(Long var1);

        public Builder lastModifiedDate(Date var1);
    }
}

