/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VerificationMessageTemplateTypeMarshaller {
    private static final MarshallingInfo<String> SMSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsMessage").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailMessage").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILSUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailSubject").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILMESSAGEBYLINK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailMessageByLink").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILSUBJECTBYLINK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailSubjectByLink").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTEMAILOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultEmailOption").isBinary(false).build();
    private static final VerificationMessageTemplateTypeMarshaller INSTANCE = new VerificationMessageTemplateTypeMarshaller();

    private VerificationMessageTemplateTypeMarshaller() {
    }

    public static VerificationMessageTemplateTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VerificationMessageTemplateType verificationMessageTemplateType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)verificationMessageTemplateType, (String)"verificationMessageTemplateType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)verificationMessageTemplateType.smsMessage(), SMSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)verificationMessageTemplateType.emailMessage(), EMAILMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)verificationMessageTemplateType.emailSubject(), EMAILSUBJECT_BINDING);
            protocolMarshaller.marshall((Object)verificationMessageTemplateType.emailMessageByLink(), EMAILMESSAGEBYLINK_BINDING);
            protocolMarshaller.marshall((Object)verificationMessageTemplateType.emailSubjectByLink(), EMAILSUBJECTBYLINK_BINDING);
            protocolMarshaller.marshall((Object)verificationMessageTemplateType.defaultEmailOptionAsString(), DEFAULTEMAILOPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

