/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserTypeMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();
    private static final MarshallingInfo<List> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<Instant> USERCREATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserCreateDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> USERLASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserLastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> USERSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserStatus").isBinary(false).build();
    private static final MarshallingInfo<List> MFAOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MFAOptions").isBinary(false).build();
    private static final UserTypeMarshaller INSTANCE = new UserTypeMarshaller();

    private UserTypeMarshaller() {
    }

    public static UserTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserType userType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userType, (String)"userType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userType.username(), USERNAME_BINDING);
            protocolMarshaller.marshall(userType.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)userType.userCreateDate(), USERCREATEDATE_BINDING);
            protocolMarshaller.marshall((Object)userType.userLastModifiedDate(), USERLASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)userType.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)userType.userStatusAsString(), USERSTATUS_BINDING);
            protocolMarshaller.marshall(userType.mfaOptions(), MFAOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

