/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserPoolTypeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> POLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Policies").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LAMBDACONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LambdaConfig").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<List> SCHEMAATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> AUTOVERIFIEDATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoVerifiedAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> ALIASATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AliasAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> USERNAMEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UsernameAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> SMSVERIFICATIONMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsVerificationMessage").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILVERIFICATIONMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailVerificationMessage").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILVERIFICATIONSUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailVerificationSubject").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VERIFICATIONMESSAGETEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VerificationMessageTemplate").isBinary(false).build();
    private static final MarshallingInfo<String> SMSAUTHENTICATIONMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsAuthenticationMessage").isBinary(false).build();
    private static final MarshallingInfo<String> MFACONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MfaConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DEVICECONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Integer> ESTIMATEDNUMBEROFUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EstimatedNumberOfUsers").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EMAILCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SMSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Map> USERPOOLTAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolTags").isBinary(false).build();
    private static final MarshallingInfo<String> SMSCONFIGURATIONFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SmsConfigurationFailure").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILCONFIGURATIONFAILURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailConfigurationFailure").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ADMINCREATEUSERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdminCreateUserConfig").isBinary(false).build();
    private static final UserPoolTypeMarshaller INSTANCE = new UserPoolTypeMarshaller();

    private UserPoolTypeMarshaller() {
    }

    public static UserPoolTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserPoolType userPoolType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userPoolType, (String)"userPoolType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userPoolType.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.policies(), POLICIES_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.lambdaConfig(), LAMBDACONFIG_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall(userPoolType.schemaAttributes(), SCHEMAATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolType.autoVerifiedAttributesAsStrings(), AUTOVERIFIEDATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolType.aliasAttributesAsStrings(), ALIASATTRIBUTES_BINDING);
            protocolMarshaller.marshall(userPoolType.usernameAttributesAsStrings(), USERNAMEATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.smsVerificationMessage(), SMSVERIFICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.emailVerificationMessage(), EMAILVERIFICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.emailVerificationSubject(), EMAILVERIFICATIONSUBJECT_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.verificationMessageTemplate(), VERIFICATIONMESSAGETEMPLATE_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.smsAuthenticationMessage(), SMSAUTHENTICATIONMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.mfaConfigurationAsString(), MFACONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.deviceConfiguration(), DEVICECONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.estimatedNumberOfUsers(), ESTIMATEDNUMBEROFUSERS_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.emailConfiguration(), EMAILCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.smsConfiguration(), SMSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(userPoolType.userPoolTags(), USERPOOLTAGS_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.smsConfigurationFailure(), SMSCONFIGURATIONFAILURE_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.emailConfigurationFailure(), EMAILCONFIGURATIONFAILURE_BINDING);
            protocolMarshaller.marshall((Object)userPoolType.adminCreateUserConfig(), ADMINCREATEUSERCONFIG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

