/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserPoolPolicyTypeMarshaller {
    private static final MarshallingInfo<StructuredPojo> PASSWORDPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PasswordPolicy").isBinary(false).build();
    private static final UserPoolPolicyTypeMarshaller INSTANCE = new UserPoolPolicyTypeMarshaller();

    private UserPoolPolicyTypeMarshaller() {
    }

    public static UserPoolPolicyTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserPoolPolicyType userPoolPolicyType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userPoolPolicyType, (String)"userPoolPolicyType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userPoolPolicyType.passwordPolicy(), PASSWORDPOLICY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

